<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require('../incfiles/core.php');
$lng_profile = core::load_lng('profile');

/*
-----------------------------------------------------------------
Закрываем от неавторизованных юзеров
-----------------------------------------------------------------
*/
if (!$user_id) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['access_guest_forbidden']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Получаем данные пользователя
-----------------------------------------------------------------
*/
$user = functions::get_user($user);
if (!$user) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['user_does_not_exist']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Переключаем режимы работы
-----------------------------------------------------------------
*/
$array = array(
    'activity'  => 'includes/profile',
    'ban'       => 'includes/profile',
    'edit'      => 'includes/profile',
    'images'    => 'includes/profile',
    'info'      => 'includes/profile',
    'ip'        => 'includes/profile',
    'guestbook' => 'includes/profile',
    'karma'     => 'includes/profile',
    'office'    => 'includes/profile',
    'password'  => 'includes/profile',
    'reset'     => 'includes/profile',
    'settings'  => 'includes/profile',
    'stat'      => 'includes/profile',
    'friends'   => 'includes/profile',
	 'notification'   => 'includes/profile'
);
$path = !empty($array[$act]) ? $array[$act] . '/' : '';
if (array_key_exists($act, $array) && file_exists($path . $act . '.php')) {
    require_once($path . $act . '.php');
} else {
    /*
    -----------------------------------------------------------------
    Анкета пользователя
    -----------------------------------------------------------------
    */
    $headmod = 'profile,' . $user['id'];
    $textl = ''.htmlspecialchars($user['name']).' — MMUZON.RU';
    require('../incfiles/head.php');
    echo '<div class="phdr"><b>' . ($user['id'] != $user_id ? 'Ulanyjy profili' : 'Meniň profilim') . '</b></div>';

    // Меню анкеты
    $menu = array();
    if ($user['id'] == $user_id || $rights == 9 || ($rights == 7 && $rights > $user['rights'])) {
        $menu[] = '<a href="profile.php?act=edit&amp;user=' . $user['id'] . '">Üýtget</a>';
    }
    if ($user['id'] != $user_id && $rights >= 7 && $rights > $user['rights']) {
        $menu[] = '<a href="' . $set['homeurl'] . '/' . $set['admp'] . '/index.php?act=usr_del&amp;id=' . $user['id'] . '">Poz</a>';
    }
    if ($user['id'] != $user_id && $rights > $user['rights']) {
        $menu[] = '<a href="profile.php?act=ban&amp;mod=do&amp;user=' . $user['id'] . '">BANla</a>';
    }
    if (!empty($menu)) {
        echo '<div class="topmenu">' . functions::display_menu($menu) . '</div>';
    }

    //Уведомление о дне рожденья
    if ($user['dayb'] == date('j', time()) && $user['monthb'] == date('n', time())) {
        echo '<div class="menu">' . $lng['birthday'] . '!!!</div>';
    }

    // Информация о юзере
    $arg = array(
        'lastvisit' => 1,
        'iphist'    => 1,
        'header'    => '<b>ID:' . $user['id'] . '</b>'
    );

    if ($user['id'] != core::$user_id) {
        $arg['footer'] = '<span class="gray">' . core::$lng['where'] . ':</span> ' . functions::display_place($user['id'], $user['place']);
    }

    echo '<div class="menu"><p>' . functions::display_user($user, $arg) . '</p></div>';
    // Если юзер ожидает подтверждения регистрации, выводим напоминание
    if ($rights >= 7 && !$user['preg'] && empty($user['regadm'])) {
        echo '<div class="rmenu">' . $lng_profile['awaiting_registration'] . '</div>';
    }

    // Меню выбора
    $total_photo = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = '" . $user['id'] . "'"), 0);
    echo '<div class="menu"><p>' .
        '<div><a href="profile.php?act=info&amp;user=' . $user['id'] . '">Maglumat</a></div>' .
		$notif = mysql_result(mysql_query("SELECT COUNT(`id`) FROM `notification` WHERE `user_id` = '$user[id]' AND `read` = '1';"), 0);
$notif = (!empty($notif)) ? ' <span style="color: #F78F8F;">+' . $notif . '</span>' : '';
echo '<div><a href="profile.php?act=notification&user=' . $user['id'] . '">Bildirişler</a>'.$notif.'</div></div>';
    if ($user['id'] != $user_id) {
        echo '<div class="menu"><p>';
        // Контакты

        if (functions::is_contact($user['id']) != 2) {
            if (!functions::is_contact($user['id'])) {
                echo '<div><a href="../mail/index.php?id=' . $user['id'] . '">Kontakta goş</a></div>';
            } else {
                echo '<div><a href="../mail/index.php?act=deluser&amp;id=' . $user['id'] . '">Kontaktdan poz</a></div>';
            }
        }

        if (functions::is_contact($user['id']) != 2) {
            echo '<div><a href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;add">Gara sanawa goş</a></div>';
        } else {
            echo '<div><a href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;del">Gara sanawdan poz</a></div>';
        }
        echo '</p>';

        if (!functions::is_ignor($user['id']) && functions::is_contact($user['id']) != 2 && empty($ban['1']) && empty($ban['3'])) {
            echo '<p><form action="../mail/index.php?act=write&amp;id=' . $user['id'] . '" method="post"><input type="submit" value="Şahsy habar ýaz" style="margin-left: 18px"/></form></p>';
        }
        echo '</div>';
    }
    echo '<div class="phdr"><a href="../">Baş sahypa</a></div>';
}

require_once('../incfiles/end.php');