<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	 <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	  <link rel="shortcut icon" href="{THEME}/images/favicon.png" />
	  <link href="{THEME}/style/styles.css" type="text/css" rel="stylesheet" />
	  <link href="{THEME}/style/engine.css" type="text/css" rel="stylesheet" />
	  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,400i,600,800&amp;subset=cyrillic" rel="stylesheet"> 
	  <meta name="theme-color" content="#8e44ad">
</head>

<body>

<div class="wrap">

	<div class="wrap-center wrap-main">
	
		<div class="cols fx-row">
		
			<aside class="col-left">
				<div class="btn-menu"><span class="fa fa-bars"></span></div>
				<a href="/" class="logo"><img src="{theme}/images/logo.png" alt="" /></a>
				<div class="side-box">
					<div class="side-bt">Навигация</div>
					<ul class="side-bc side-nav">
						<li class="submenu"><a href="#">Русское (открыто)</a><div class="menu-btn-toggle"><span class="fa fa-angle-up"></span></div>
							<ul class="hidden-menu">
								<li><a href="#">Поп</a></li>
								<li><a href="#">Русская попса</a></li>
								<li><a href="#">Танцевальная</a></li>
								<li><a href="#">Клубная</a></li>
								<li><a href="#">Хаус</a></li>
								<li><a href="#">Дип хаус</a></li>
							</ul>
						</li>
						<li class="submenu"><a href="#">Это меню закрыто</a><div class="menu-btn-toggle"><span class="fa fa-angle-down"></span></div>
							<ul class="hidden-menu hidden">
								<li><a href="#">Поп</a></li>
								<li><a href="#">Русская попса</a></li>
								<li><a href="#">Танцевальная</a></li>
								<li><a href="#">Клубная</a></li>
								<li><a href="#">Хаус</a></li>
								<li><a href="#">Дип хаус</a></li>
							</ul>
						</li>
						<li><a href="#">Русские новинки</a></li>
						<li><a href="#">Зарубежные новинки</a></li>
						<li><a href="#">Новогодняя музыка</a></li>
						<li><a href="#">Исполнители</a></li>
						<li><a href="#">Альбомы</a></li>
						<li><a href="#">Радио</a></li>
					</ul>
				</div>
				<div class="side-box">
					<div class="side-bt">Топ треков</div>
					<div class="side-bc">{custom category="1-10" limit="10" template="custom-toptrack" cache="no"}</div>
				</div>
				<div class="side-box">
					<div class="side-bt">Топ артисты</div>
					<div class="side-bc fx-row">{custom category="1-10" limit="9" template="custom-topartist" cache="no"}</div>
				</div>
			</aside>
			
			<!-- COL-LEFT -->
			
			<div class="col-main fx-1">
			
				<div class="topline fx-row">
					<div class="share"></div>
					<div class="search-wrap fx-1">
						<form id="quicksearch" method="post">
							<input type="hidden" name="do" value="search" />
							<input type="hidden" name="subaction" value="search" />
							<div class="search-box">
								<input id="story" name="story" placeholder="поиск музыки..." type="text" />
								<button type="submit"><span class="fa fa-search"></span></button>
							</div>
						</form>
					</div>
					{login}
				</div>
				
				<main class="content">
					{info}
					[not-aviable=main|cat]<div class="speedbar nowrap">{speedbar}</div>[/not-aviable]
					[aviable=main]{include file="main-page.tpl"}[/aviable]
					{include file="main-seo.tpl"}
					[aviable=cat|favorites]
					<div class="sect sect-count">
						<div class="sect-header fx-row fx-middle">
							[aviable=cat]<div class="sect-title fx-1">{category-title}</div>[/aviable]
							[aviable=favorites]<div class="sect-title fx-1">Мое избранное</div>[/aviable]
						</div>
						<div class="sect-content">
							{content}
						</div>
					</div>
					[/aviable]
					[not-aviable=main|cat|favorites]{content}[/not-aviable]
				</main>
				
			</div>
			
			<!-- COL-MAIN -->
			
		</div>
		
		<!-- COLS -->
	
	</div>
	
	<!-- END WRAP-CENTER -->
	
	<footer class="footer wrap-center">
		<div class="ft-one fx-row">
			<span>Все права защищены , 2018, Muzonator</span> 
			<div class="fx-1"><a href="#">DMCA</a> <a href="#">Обратная связь</a> <a href="#">Обращение к пользователям</a></div>
		</div>
		<div class="ft-two">
			Администрация не несет ответственности за размещенные пользователями нелегальные материалы! Любой аудио файл будет удален по требованию 
			правообладателя. Все файлы проверены, вирусов нет. Наш плеер поддерживает все устройтва на Андройде и IOS (Iphone, Айпад).
		</div>
	</footer>
	
	<!-- COL-FOOTER -->

</div>

<!-- END WRAP -->

{jsfiles}
<script src="{THEME}/js/libs.js"></script>
{AJAX}

</body>
</html>
