<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<link rel="shortcut icon" href="{THEME}/images/logo.svg" />
	<link href="{THEME}/css/styles.css" type="text/css" rel="stylesheet" />
	<link href="{THEME}/css/engine.css" type="text/css" rel="stylesheet" />
	<meta name="theme-color" content="#111">
	<link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600&display=swap&subset=cyrillic" rel="stylesheet">  
</head>

<body id="hideme" class="not-loaded">

	<div class="wrap">

		<header class="header">
			<div class="header-in wrap-center fx-row fx-middle">
				<a href="/" class="logo nowrap"><span>Chi</span>Da?<span class="logo-domain">.net</span></a>
				<div class="search-wrap fx-1">
					<form id="quicksearch" method="post">
						<input type="hidden" name="do" value="search" />
						<input type="hidden" name="subaction" value="search" />
						<div class="search-box">
							<input id="story" name="story" placeholder="Поиск по сайту..." type="text" />
							<button type="submit" class="search-btn"><span class="fal fa-search"></span></button>
						</div>
					</form>
				</div>
				[group=5]<div class="header-btn btn js-login">Авторизация</div>[/group]
				[not-group=5]<div class="header-btn btn js-login">Кабинет</div>[/not-group]
				<div class="btn-menu hidden"><span class="fal fa-bars"></span></div>
			</div>
		</header>
		
		<!-- END HEADER -->
		
		<div class="wrap-main wrap-center">
	
			<div class="cols fx-row">

				<aside class="col-left">
					<ul class="side-box side-nav to-mob"> <!-- все что отметите to mob будет в меню телефона -->
						<li class="submenu">
							<span class="fal fa-list-music"></span><a href="#">Выбор жанра</a>
							<ul class="hidden-menu fx-row anim">
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
							</ul>
						</li>
						<li><span class="fal fa-compact-disc"></span><a href="#">Хиты 2020</a></li>
						<li><span class="fal fa-trophy"></span><a href="#">Наш чарт</a></li>
						<li><span class="fal fa-dumbbell"></span><a href="#">Где брать</a></li>
						<li><span class="fal fa-glass-cheers"></span><a href="#">тематические</a></li>
						<li><span class="fal fa-tire"></span><a href="#">иконки</a></li>
						<li><span class="fal fa-folders"></span><a href="#">смотрите</a></li>
						<li><span class="fal fa-album-collection"></span><a href="#">в инструкции</a></li>
						<li><span class="fal fa-radio"></span><a href="/">Чи да?</a></li>
					</ul>
					<div class="side-box side-text">
						Просто пара строк тематического текста про прослушивание онлайн и скачивание. Сео фишечки.
					</div>
					<ul class="side-box side-links fx-row fx-start">
						<li><a href="/">Ссылка</a></li>
						<li><a href="#">Ссылка</a></li>
						<li><a href="#">Ссылка</a></li>
					</ul>
				</aside>
				
				<!-- END COL-LEFT -->

				<main class="col-main fx-1" id="wajax">
					{info}
					[available=main]{include file="main-page.tpl"}[/available]
					[not-available=main|showfull]
					<div class="sect sect-bg">
						[available=cat]<div class="sect-header sect-title">{category-title}</div>[/available]
						[available=favorites]<div class="sect-header sect-title">Мое избранное</div>[/available]
						<div class="sect-content">
							{content}
						</div>
					</div>
					[/not-available]
					[available=showfull]{content}[/available]
				</main>
				
				<!-- END COL-MAIN -->

				<aside class="col-right">
					<div class="side-box sect-bg">
						<div class="side-bt">Топ треков за день</div>
						<div class="side-bc">
							{custom category="27" limit="6" template="custom-side-top" cache="no"}
						</div>
					</div>
					<div class="side-box sect-bg side-subscribe">
						<div class="side-bt"><span class="fal fa-envelope"></span>Будь в курсе!</div>
						<div class="side-bc search-box">
							<input name="" placeholder="Ваша почта" type="text" />
							<button type="submit" class="search-btn"><span class="fal fa-arrow-right"></span></button>
							<div class="side-subscribe-caption">Новая музыка каждый день!</div>
						</div>
					</div>
					<div class="side-box sect-bg">
						<div class="side-bt">Популярное за месяц</div>
						<div class="side-bc">
							{custom category="27" limit="10" template="custom-side" cache="no"}
						</div>
					</div>
				</aside>
				
				<!-- END COL-RIGHT -->

			</div>

			<!-- END COLS -->

			<footer class="footer fx-row fx-middle">
				<div class="footer-copyright">© Яндекс Музыка 2020. Пишите письма на: <span>yandexmusic@yandex.ru</span></div>
				<div class="footer-counter"><img src="{theme}/images/counter.gif" alt=""></div>
			</footer>

		</div>

		<!-- END WRAP-MAIN -->

	</div>
	
	<!-- END WRAP -->
		
{login}
{jsfiles}
<script src="{THEME}/js/libs.js"></script>
{AJAX}


</body>
</html>
