<?php
# Paket nomi:			CleverCMS
# Mualliflik huquqi:	2018-2020 Clever Group
# Muallif:				Сардорбек Ўктамов

defined('CleverCMS') or die('Xato: Foydalanish cheklangan');

# Sessiya nomi
session_name('ses');
# Sessiya boshlanishi
session_start();

# Xatoliklarni yashirish
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', true);
ini_set('html_errors', true);
ini_set('error_reporting', E_ALL ^ E_NOTICE);

ini_set('session.cookie_lifetim', '0');
ini_set('zlib.output_compression', '1');
ini_set('arg_separator.output', '&amp;');
ini_set('register_globals', '0');
ini_set('magic_quotes_gpc', '0');
mb_internal_encoding('UTF-8');

# Soat mintaqasi
date_default_timezone_set('Asia/Tashkent');

# Ildiz
define ('root', $_SERVER['DOCUMENT_ROOT'].'/');
# Asosiy bo'lim
define ('core', root.'core/');
# Qo'shimcha bo'lim
define ('inc', core.'inc/');
# Vazifalar bo'limi
define ('fnc', core.'fnc/');
# Classlar bo'limi
define ('classes', core.'classes/');

# Ma'lumotlar bazasi
require (inc.'config.php');
# PDO tizimi
require (inc.'pdo.php');
# Asosiy tizm ma'lumotlari
require (inc.'core.php');

# Avtomatik vazifalarni yuklash
$opdirbase = opendir(fnc);
while ($filebase = readdir($opdirbase)) 
{
	if (preg_match('#\.php$#i',$filebase)) 
	{
		include_once(fnc.''.$filebase);
	}
}

# Avtomatik classlarni yuklash
$opdirbase = opendir(classes);
while ($filebase = readdir($opdirbase)) 
{
	if (preg_match('#\.php$#i',$filebase)) 
	{
		include_once(classes.''.$filebase);
	}
}

# Foydalanuvchilar uchun
require (inc.'user.php');
# Tepa qism
define ('head', inc.'head.php');
# Pastki qism
define ('foot', inc.'foot.php');

?>