
CREATE TABLE `chat` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `text` text,
  `quote` text,
  `time` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `chat_lenta` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `config` (
  `title` varchar(255) NOT NULL,
  `copyright` varchar(255) NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `email` varchar(32) NOT NULL,
  `url` varchar(32) NOT NULL,
  `pages` int(11) DEFAULT NULL,
  `close_reg` enum('on','off') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `config` (`title`, `copyright`, `keywords`, `description`, `email`, `url`, `pages`, `close_reg`) VALUES
('CleverCMS - O&#039;zbekona milliy CMS', 'Powered by Сардорбек Ўктамов', 'CleverCMS v0.2 beta', 'CleverCMS v0.2 beta', 'sardorjon97@bk.ru', 'http://clevercms.ru', 12, 'on');


CREATE TABLE `guestbook` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `text` longtext NOT NULL,
  `time` int(11) NOT NULL,
  `admin_id` int(11) NOT NULL,
  `reply_text` longtext NOT NULL,
  `reply_time` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `guests` (
  `id` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `ua` text NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `positions` (
  `id` int(11) NOT NULL,
  `position` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `positions` (`id`, `position`) VALUES
(1, 'Moderator'),
(2, 'Admin o`rinbosari'),
(3, 'Adminstrator'),
(4, 'Sayt yaratuvchisi'),
(6, 'Yordamchi');


CREATE TABLE `privilege` (
  `id` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `privil` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `read` enum('on','off') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `privilege` (`id`, `pos`, `privil`, `title`, `read`) VALUES
(1, 4, 'settings', 'Sayt sozlamalri', 'on'),
(2, 4, 'news', 'Yangiliklarni boshqarish', 'on'),
(3, 4, 'guestbook', 'Mehmonxonani boshqarish', 'on'),
(4, 4, 'chat', 'Chatni boshqarish', 'on'),
(5, 4, 'anceta_update', 'Anketalarni tahrirlash', 'on'),
(6, 4, 'anceta_delete', 'Anketalarni o`chirish', 'on'),
(7, 4, 'anceta_bann', 'Foydalanuvchiga ban berish', 'on'),
(8, 4, 'positions', 'Lavozim imtiyozlarini boshqarish', 'on');


CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nick` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `surname` varchar(64) NOT NULL,
  `gender` enum('w','m') NOT NULL,
  `bday` int(2) DEFAULT NULL,
  `bmonth` int(2) DEFAULT NULL,
  `byear` int(4) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `status` text NOT NULL,
  `set_stastus` enum('0','1') DEFAULT '0',
  `adress` varchar(255) NOT NULL,
  `token` varchar(32) NOT NULL,
  `level` int(11) NOT NULL,
  `email` varchar(255) NOT NULL,
  `balls` int(11) DEFAULT '0',
  `uzs` int(11) DEFAULT '0',
  `rubl` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  `time_reg` int(11) NOT NULL,
  `time_last` int(11) NOT NULL,
  `config_pages` int(11) NOT NULL DEFAULT '7',
  `ip` varchar(15) NOT NULL,
  `ua` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `users` (`id`, `login`, `password`, `nick`, `name`, `surname`, `gender`, `bday`, `bmonth`, `byear`, `photo`, `status`, `set_stastus`, `adress`, `token`, `level`, `email`, `balls`, `uzs`, `rubl`, `time`, `time_reg`, `time_last`, `config_pages`, `ip`, `ua`) VALUES
(1, 'clever', 'd893826effe986dc28a813c7825a14a7', 'Clever', 'Sardorbek', '', 'm', 21, 8, 1997, NULL, '', '0', '12', '6a9782df969b66817702ad59a4185bb1', 4, '', 0, 0, 0, 12890, 1592457261, 1592640399, 7, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0');


CREATE TABLE `users_guests` (
  `id` int(11) NOT NULL,
  `ank_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '1',
  `count` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `chat`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `chat_lenta`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `guestbook`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `guests`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `positions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `privilege`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `users`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `users_guests`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `chat`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `chat_lenta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

ALTER TABLE `guestbook`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

ALTER TABLE `guests`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

ALTER TABLE `positions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

ALTER TABLE `privilege`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `users_guests`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
COMMIT;
