<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	 <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	  <link rel="shortcut icon" href="{THEME}/images/favicon.svg" />
	  <link href="{THEME}/style/styles.css" type="text/css" rel="stylesheet" />
	  <link href="{THEME}/style/engine.css" type="text/css" rel="stylesheet" />
	  <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600&display=swap&subset=cyrillic" rel="stylesheet"> 
	  <meta name="theme-color" content="#b564d9">
</head>

<body>

<div class="wrap">

	<div class="wrap-center wrap-main">
	
		<div class="cols fx-row [available=showfull] cols-full[/available]" id="cols">
		
			<aside class="col-left">
				<div class="side-box to-mob">
					<div class="side-bt">Меню</div>
					<ul class="side-bc side-nav">
						<li><a href="#"><span class="myicon-home-run"></span>Главная</a></li>
						<li><a href="#"><span class="myicon-music"></span>Хиты весны 2020</a></li>
						<li><a href="#"><span class="myicon-genres"></span>Подборки</a></li>
						<li class="submenu"><a href="#" title="показать скрыть меню" data-rel="tooltip" data-move="menu"><span class="myicon-genres2"></span>Жанры</a>
							<ul class="hidden-menu">
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
								<li><a href="#">Ссылка</a></li>
							</ul>
						</li>
						<li><a href="#"><span class="myicon-hot"></span>Топ 100</a></li>
						<li><a href="#"><span class="myicon-radio"></span>Радио</a></li>
					</ul>
				</div>
				<div class="side-box to-mob">
					<div class="side-bt">Топ хитов</div>
					<div class="side-bc">{custom category="1-27" limit="8" template="custom-toptrack" cache="no"}</div>
				</div>
				<div class="side-box to-mob">
					<div class="side-bt">В эфире</div>
					<div class="side-bc fx-row">{custom category="1-27" limit="3" template="custom-topradio" cache="no"}</div>
				</div>
			</aside>
			
			<!-- COL-LEFT -->
			
			<div class="col-main fx-1">
			
				<header class="header fx-row fx-middle">
					<a href="/" class="logo">2playmusic</a>
					<div class="search-wrap">
						<form id="quicksearch" method="post">
							<input type="hidden" name="do" value="search" />
							<input type="hidden" name="subaction" value="search" />
							<div class="search-box">
								<input id="story" name="story" placeholder="Поиск музыки" type="text" />
								<button type="submit"><span class="myicon-search-1"></span></button>
							</div>
						</form>
					</div>
					<div class="header-login">
						[group=5]<div class="btn-login btn js-login">Вход</div>[/group]
						[not-group=5]<div class="btn-login btn js-login">Кабинет</div>[/not-group]
						[group=5]<div class="header-login-message anim"><b>Войдите на сайт</b>, чтобы создавать свои плейлисты</div>[/group]
					</div>
					<div class="btn-menu"><span class="fa fa-bars"></span></div>
				</header>
				
				<main class="content" id="wajax">
					{info}
					[not-available=main|cat]<div class="speedbar nowrap">{speedbar}</div>[/not-available]
					[available=main]{include file="main-page.tpl"}[/available]
					{include file="main-seo.tpl"}
					[available=cat|favorites]
					<div class="sect">
						[available=cat]<div class="sect-title sect-header">{category-title}</div>[/available]
						[available=favorites]<div class="sect-title sect-header">Мое избранное</div>[/available]
						<div class="sect-content sect-items">
							{content}
						</div>
					</div>
					[/available]
					[not-available=main|cat|favorites]{content}[/not-available]
				</main>
				
			</div>
			
			<!-- COL-MAIN -->
			
		</div>
		
		<!-- COLS -->
	
		<footer class="footer fx-row fx-middle">
			<ul class="footer-menu fx-row fx-start fx-1">
				<li><a href="#">Ссылка</a></li>
				<li><a href="#">Ссылка</a></li>
				<li><a href="#">Ссылка</a></li>
			</ul>
			<div class="footer-copyright">
				Ваш сайт - Самый лучший сайт © 2020 <br>Все права защищены. 
			</div>
		</footer>
		
		<!-- FOOTER -->

	</div>
	
	<!-- END WRAP-CENTER -->

</div>

<!-- END WRAP -->

<div class="share-box hidden" data-image="{theme}/images/logo.png">
	<div class="share-box-title">Поделиться треком с друзьями!</div>
	<div class="hshare fx-row fx-center" data-link="">
		<span class="fa fa-facebook-f" data-id="fb"></span>
		<span class="fa fa-vk" data-id="vk"></span>
		<span class="fa fa-odnoklassniki" data-id="ok"></span>
		<span class="fa fa-twitter" data-id="tw"></span>
		<span class="fa fa-paper-plane" data-id="tlg"></span>
	</div>
	<div class="share-box-direct">
		<div>Прямая ссылка</div>
		<input type="text" class="fx-1" onclick="this.select()">
	</div>
</div>
{login}
{jsfiles}
<script src="{THEME}/js/libs.js"></script>
{AJAX}

</body>
</html>
