--
-- Структура таблицы `cms_ads`
--
DROP TABLE IF EXISTS `cms_ads`;
CREATE TABLE `cms_ads` (
  `id`         INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `type`       TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `view`       TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `layout`     TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `count`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `count_link` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`       TEXT                NOT NULL,
  `link`       TEXT                NOT NULL,
  `to`         INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `color`      VARCHAR(10)         NOT NULL DEFAULT '',
  `time`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `day`        INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `mesto`      TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `bold`       TINYINT(1)          NOT NULL DEFAULT '0',
  `italic`     TINYINT(1)          NOT NULL DEFAULT '0',
  `underline`  TINYINT(1)          NOT NULL DEFAULT '0',
  `show`       TINYINT(1)          NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_cat`
--
DROP TABLE IF EXISTS `cms_album_cat`;
CREATE TABLE `cms_album_cat` (
  `id`          INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `sort`        INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`        VARCHAR(40)         NOT NULL DEFAULT '',
  `description` TEXT                NOT NULL,
  `password`    VARCHAR(20)         NOT NULL DEFAULT '',
  `access`      TINYINT(4) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_comments`
--
DROP TABLE IF EXISTS `cms_album_comments`;
CREATE TABLE `cms_album_comments` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `text`       TEXT             NOT NULL,
  `reply`      TEXT             NOT NULL,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_downloads`
--
DROP TABLE IF EXISTS `cms_album_downloads`;
CREATE TABLE `cms_album_downloads` (
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`, `file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_files`
--
DROP TABLE IF EXISTS `cms_album_files`;
CREATE TABLE `cms_album_files` (
  `id`              INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`         INT(10) UNSIGNED    NOT NULL,
  `album_id`        INT(10) UNSIGNED    NOT NULL,
  `description`     TEXT                NOT NULL,
  `img_name`        VARCHAR(100)        NOT NULL DEFAULT '',
  `tmb_name`        VARCHAR(100)        NOT NULL DEFAULT '',
  `time`            INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `comments`        TINYINT(1)          NOT NULL DEFAULT '1',
  `comm_count`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `access`          TINYINT(4) UNSIGNED NOT NULL DEFAULT '0',
  `vote_plus`       INT(11)             NOT NULL DEFAULT '0',
  `vote_minus`      INT(11)             NOT NULL DEFAULT '0',
  `views`           INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `downloads`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `unread_comments` TINYINT(1)          NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_views`
--
DROP TABLE IF EXISTS `cms_album_views`;
CREATE TABLE `cms_album_views` (
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`, `file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_votes`
--
DROP TABLE IF EXISTS `cms_album_votes`;
CREATE TABLE `cms_album_votes` (
  `id`      INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `vote`    TINYINT(2)       NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_ban_ip`
--
DROP TABLE IF EXISTS `cms_ban_ip`;
CREATE TABLE `cms_ban_ip` (
  `id`       INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ip1`      BIGINT(11)       NOT NULL DEFAULT '0',
  `ip2`      BIGINT(11)       NOT NULL DEFAULT '0',
  `ban_type` TINYINT(4)       NOT NULL DEFAULT '0',
  `link`     VARCHAR(100)     NOT NULL,
  `who`      VARCHAR(25)      NOT NULL,
  `reason`   TEXT             NOT NULL,
  `date`     INT(11)          NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_ban_users`
--
DROP TABLE IF EXISTS `cms_ban_users`;
CREATE TABLE `cms_ban_users` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`    INT(11)          NOT NULL DEFAULT '0',
  `ban_time`   INT(11)          NOT NULL DEFAULT '0',
  `ban_while`  INT(11)          NOT NULL DEFAULT '0',
  `ban_type`   TINYINT(4)       NOT NULL DEFAULT '1',
  `ban_who`    VARCHAR(30)      NOT NULL DEFAULT '',
  `ban_ref`    INT(11)          NOT NULL DEFAULT '0',
  `ban_reason` TEXT             NOT NULL,
  `ban_raz`    VARCHAR(30)      NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_contact`
--
DROP TABLE IF EXISTS `cms_contact`;
CREATE TABLE IF NOT EXISTS `cms_contact` (
  `id`      INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `from_id` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `type`    TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
  `friends` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `ban`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `man`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`, `from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_counters`
--
DROP TABLE IF EXISTS `cms_counters`;
CREATE TABLE `cms_counters` (
  `id`     INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sort`   INT(10)          NOT NULL DEFAULT '1',
  `name`   VARCHAR(30)      NOT NULL,
  `link1`  TEXT             NOT NULL,
  `link2`  TEXT             NOT NULL,
  `mode`   TINYINT(4)       NOT NULL DEFAULT '1',
  `switch` TINYINT(1)       NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_files`
--
DROP TABLE IF EXISTS `cms_forum_files`;
CREATE TABLE `cms_forum_files` (
  `id`       INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `cat`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `subcat`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `topic`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `post`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `time`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `filename` TEXT                NOT NULL,
  `filetype` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `dlcount`  INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `del`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_rdm`
--
DROP TABLE IF EXISTS `cms_forum_rdm`;
CREATE TABLE `cms_forum_rdm` (
  `topic_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`     INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`, `user_id`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_rdm2`
--
DROP TABLE IF EXISTS `cms_forum_rdm2`;
CREATE TABLE `cms_forum_rdm2` (
  `topic_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`     INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`, `user_id`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_vote`
--
DROP TABLE IF EXISTS `cms_forum_vote`;
CREATE TABLE `cms_forum_vote` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type`  INT(2)           NOT NULL DEFAULT '0',
  `time`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `topic` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name`  VARCHAR(200)     NOT NULL,
  `count` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_vote_users`
--
DROP TABLE IF EXISTS `cms_forum_vote_users`;
CREATE TABLE `cms_forum_vote_users` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user`  INT(11)          NOT NULL DEFAULT '0',
  `topic` INT(11)          NOT NULL,
  `vote`  INT(11)          NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_mail`
--
DROP TABLE IF EXISTS `cms_mail`;
CREATE TABLE IF NOT EXISTS `cms_mail` (
  `id`        INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `from_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `text`      TEXT                NOT NULL,
  `from`      VARCHAR(25)         NOT NULL DEFAULT '',
  `time`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `read`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `sys`       TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `delete`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `file_name` VARCHAR(100)        NOT NULL DEFAULT '',
  `count`     INT(10)             NOT NULL DEFAULT '0',
  `size`      INT(10)             NOT NULL DEFAULT '0',
  `them`      VARCHAR(100)        NOT NULL DEFAULT '',
  `spam`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
INSERT INTO `cms_mail` (`id`, `user_id`, `from_id`, `text`, `time`, `read`, `sys`, `delete`, `file_name`, `count`, `size`, `them`, `spam`)
VALUES ('1', '2', '1', 'Salam, hormatly admin! Men Pälwan Akmyradow[ZET-PRO2003].
Ilki bilen sizi täze saýtyňyz bilen gutlaýaryn! Şu saýt üçin meniň modlan skriptimi saýlanyňyza begenjimiň çägi ýok!
Siz şahsy saýtym https://tolkun.ru -a çagyrýaryn!
Hormat bilen Pälwan Akmyradow[ZET-PRO2003]', '1443804068', '0', '0', '0', '', '0', '0', '', '0');
  
--
-- Структура таблицы `cms_sessions`
--
DROP TABLE IF EXISTS `cms_sessions`;
CREATE TABLE `cms_sessions` (
  `session_id`   CHAR(32)             NOT NULL DEFAULT '',
  `ip`           BIGINT(11)           NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)           NOT NULL DEFAULT '0',
  `browser`      VARCHAR(255)         NOT NULL DEFAULT '',
  `lastdate`     INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `sestime`      INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `views`        INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `movings`      SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
  `place`        VARCHAR(100)         NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_settings`
--
DROP TABLE IF EXISTS `cms_settings`;
CREATE TABLE `cms_settings` (
  `key` TINYTEXT NOT NULL,
  `val` TEXT     NOT NULL,
  PRIMARY KEY (`key`(30))
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

INSERT INTO `cms_settings` (`key`, `val`) VALUES
  ('active', '1'),
  ('admp', 'panel'),
  ('antiflood', 'a:5:{s:4:"mode";i:2;s:3:"day";i:10;s:5:"night";i:30;s:7:"dayfrom";i:10;s:5:"dayto";i:22;}'),
  ('clean_time', '1'),
  ('copyright', 'Tolkun.Ru - Deňiz tolkunlary ýaly reňbereň saýt!'),
  ('email', ''),
  ('flsz', '4000'),
  ('gzip', '1'),
  ('homeurl', ''),
  ('karma', 'a:6:{s:12:"karma_points";i:5;s:10:"karma_time";i:86400;s:5:"forum";i:20;s:4:"time";i:0;s:2:"on";i:1;s:3:"adm";i:0;}'),
  ('lng', 'en'),
  ('mod_reg', '2'),
  ('mod_forum', '2'),
  ('mod_guest', '2'),
  ('mod_lib', '2'),
  ('mod_gal', '2'),
  ('mod_down_comm', '1'),
  ('mod_down', '2'),
  ('mod_lib_comm', '1'),
  ('mod_gal_comm', '1'),
  ('meta_desc', 'Tolkun.Ru Created By Pälwan Akmyradow[ZET-PRO2003]... | Iň täze aýdymlar, wideolar, kinolar, elektron kitaplar, wideo sapaklar, internet kurslar, internet hyzmatlary, iň soňky täzelikler, iň soňky makaladyr mowzuklar, ajaýyp pikirler, super türkmen ýyldyzlary, dürli-hili oýunlar we fudbol stawkalary, faýllar, oýunlar, programmalar diňe Tolkun.Ru saýtynda!!!'),
  ('meta_key', 'Tolkun.Ru Created By Pälwan Akmyradow[ZET-PRO2003]... | Iň täze aýdymlar, wideolar, kinolar, elektron kitaplar, wideo sapaklar, internet kurslar, internet hyzmatlary, iň soňky täzelikler, iň soňky makaladyr mowzuklar, ajaýyp pikirler, super türkmen ýyldyzlary, dürli-hili oýunlar we fudbol stawkalary, faýllar, oýunlar, programmalar diňe Tolkun.Ru saýtynda!!!'),
  ('news', 'a:8:{s:4:"view";i:1;s:4:"size";i:200;s:8:"quantity";i:5;s:4:"days";i:3;s:6:"breaks";i:1;s:7:"smileys";i:1;s:4:"tags";i:1;s:3:"kom";i:1;}'),
  ('reg_message', ''),
  ('setting_mail', ''),
  ('skindef', 'default'),
  ('them_message', ''),
  ('timeshift', '5'),
  ('site_access', '2');

--
-- Структура таблицы `cms_users_data`
--
DROP TABLE IF EXISTS `cms_users_data`;
CREATE TABLE `cms_users_data` (
  `id`      INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `key`     VARCHAR(30)      NOT NULL DEFAULT '',
  `val`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_users_guestbook`
--
DROP TABLE IF EXISTS `cms_users_guestbook`;
CREATE TABLE `cms_users_guestbook` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(10) UNSIGNED NOT NULL,
  `time`       INT(11)          NOT NULL,
  `user_id`    INT(10) UNSIGNED NOT NULL,
  `text`       TEXT             NOT NULL,
  `reply`      TEXT             NOT NULL,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_users_iphistory`
--
DROP TABLE IF EXISTS `cms_users_iphistory`;
CREATE TABLE `cms_users_iphistory` (
  `id`           BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`      INT(10) UNSIGNED    NOT NULL,
  `ip`           BIGINT(11)          NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)          NOT NULL DEFAULT '0',
  `time`         INT(10) UNSIGNED    NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `forum`
--
DROP TABLE IF EXISTS `forum`;
CREATE TABLE `forum` (
  `id`           INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `type`         CHAR(1)          NOT NULL DEFAULT '',
  `time`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time2`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `from`         VARCHAR(25)      NOT NULL DEFAULT '',
  `realid`       INT(3)           NOT NULL DEFAULT '0',
  `ip`           BIGINT(11)       NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)       NOT NULL DEFAULT '0',
  `soft`         TEXT             NOT NULL,
  `text`         TEXT             NOT NULL,
  `close`        TINYINT(1)       NOT NULL DEFAULT '0',
  `close_who`    VARCHAR(25)      NOT NULL DEFAULT '',
  `vip`          TINYINT(1)       NOT NULL DEFAULT '0',
  `okaldy`       int(11)                   DEFAULT '0',
  `hala`         int(11)                   DEFAULT '0',
  `m_ok`         int(10) unsigned NOT NULL DEFAULT '0',
  `like`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `moway`        INT(2)           NOT NULL DEFAULT '0',
  `count_views`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `okadyk`       INT(11)          NOT NULL DEFAULT '0',
  `edit`         TEXT             NOT NULL,
  `tedit`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `kedit`        INT(2) UNSIGNED  NOT NULL DEFAULT '0',
  `curators`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `gallery`
--
DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid` INT(11)          NOT NULL DEFAULT '0',
  `time`  INT(11)          NOT NULL DEFAULT '0',
  `type`  VARCHAR(2)       NOT NULL DEFAULT '',
  `avtor` VARCHAR(25)      NOT NULL DEFAULT '',
  `text`  TEXT             NOT NULL,
  `name`  TEXT             NOT NULL,
  `user`  BINARY(1)        NOT NULL DEFAULT '\0',
  `ip`    TEXT             NOT NULL,
  `soft`  TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `avtor` (`avtor`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `guest`
--
DROP TABLE IF EXISTS `guest`;
CREATE TABLE `guest` (
  `id`         INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `adm`        TINYINT(1)          NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `user_id`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`       VARCHAR(25)         NOT NULL DEFAULT '',
  `text`       TEXT                NOT NULL,
  `ip`         BIGINT(11)          NOT NULL DEFAULT '0',
  `browser`    TINYTEXT            NOT NULL,
  `admin`      VARCHAR(25)         NOT NULL DEFAULT '',
  `otvet`      TEXT                NOT NULL,
  `otime`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `edit_who`   VARCHAR(20)         NOT NULL DEFAULT '',
  `edit_time`  INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `edit_count` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `karma_users`
--
DROP TABLE IF EXISTS `karma_users`;
CREATE TABLE `karma_users` (
  `id`         INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`       VARCHAR(50)         NOT NULL DEFAULT '',
  `karma_user` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `points`     TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `type`       TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `text`       TEXT                NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;



--
-- Структура таблицы `users`
--
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id`            INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `name`          VARCHAR(25)         NOT NULL DEFAULT '',
  `name_lat`      VARCHAR(40)         NOT NULL DEFAULT '',
  `password`      VARCHAR(32)         NOT NULL DEFAULT '',
  `rights`        TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `failed_login`  TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `imname`        VARCHAR(50)         NOT NULL DEFAULT '',
  `sex`           VARCHAR(2)          NOT NULL DEFAULT '',
  `komm`          INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `postforum`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `postguest`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `postchat`      INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `postmow`       INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `yearofbirth`   INT(4)              NOT NULL DEFAULT '0',
  `datereg`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `lastdate`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `mail`          VARCHAR(50)         NOT NULL DEFAULT '',
  `icq`           INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `skype`         VARCHAR(50)         NOT NULL DEFAULT '',
  `jabber`        VARCHAR(50)         NOT NULL DEFAULT '',
  `www`           VARCHAR(50)         NOT NULL DEFAULT '',
  `about`         TEXT                NOT NULL,
  `live`          VARCHAR(100)        NOT NULL DEFAULT '',
  `mibile`        VARCHAR(50)         NOT NULL DEFAULT '',
  `status`        VARCHAR(100)        NOT NULL DEFAULT '',
  `ip`            BIGINT(11)          NOT NULL DEFAULT '0',
  `ip_via_proxy`  BIGINT(11)          NOT NULL DEFAULT '0',
  `browser`       TEXT                NOT NULL,
  `preg`          TINYINT(1)          NOT NULL DEFAULT '0',
  `regadm`        VARCHAR(25)         NOT NULL DEFAULT '',
  `mailvis`       TINYINT(1)          NOT NULL DEFAULT '0',
  `mibilegiz`     TINYINT(1)          NOT NULL DEFAULT '0',
  `dayb`          INT(2)              NOT NULL DEFAULT '0',
  `monthb`        INT(2)              NOT NULL DEFAULT '0',
  `sestime`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `total_on_site` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `lastpost`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `rest_code`     VARCHAR(32)         NOT NULL DEFAULT '',
  `rest_time`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `movings`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `place`         VARCHAR(30)         NOT NULL DEFAULT '',
  `set_user`      TEXT                NOT NULL,
  `set_forum`     TEXT                NOT NULL,
  `set_mail`      TEXT                NOT NULL,
  `karma_plus`    INT(11)             NOT NULL DEFAULT '0',
  `karma_minus`   INT(11)             NOT NULL DEFAULT '0',
  `karma_time`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `karma_off`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `comm_count`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `comm_old`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `smileys`       TEXT                NOT NULL,
  `balans`        INT(11)             NOT NULL DEFAULT '0',
  `award`         INT(11)             NOT NULL,
  `medal`         INT(11)             NOT NULL,
  `anik`          INT(11)             NOT NULL DEFAULT '0',
  `ulgamda`       INT(11)             NOT NULL DEFAULT '0',
  `silver`        INT(11)             NOT NULL DEFAULT '0',
  `aktiwle`       INT(11)             NOT NULL DEFAULT '0',
  `bot`           INT(11)             NOT NULL,
  `wagt`          int(11)             NOT NULL,
  
  
  
  `viptime`              INT(11)             NOT NULL DEFAULT '0',
  `vipmow`               INT(11)             NOT NULL DEFAULT '0',
  `viptes`               INT(11)             NOT NULL DEFAULT '0',
  `vipplus`              INT(11)             NOT NULL DEFAULT '0',
  `vipminus`             INT(11)             NOT NULL DEFAULT '0',
  `vipsagbol`            INT(11)             NOT NULL DEFAULT '0',
  
  
  
  `time`          int(11)             NOT NULL,
  `hsagbol`       INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `hplus`         INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `hminus`        INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `hmowzuk`       INT(11) UNSIGNED    NOT NULL DEFAULT '0',
  `gor_ank`       INT(11)             NOT NULL DEFAULT '0',
  `manat`         float(11,2)         NOT NULL DEFAULT '0.00',
  `money_time`    INT(11)             NOT NULL DEFAULT '0',
  `habar_time`    INT(11)             NOT NULL DEFAULT '0',
  `cfon`          varchar(25)         NOT NULL DEFAULT '0',
  `sfon`          varchar(25)         NOT NULL DEFAULT '0',
  `cstat`         VARCHAR(25)         NOT NULL DEFAULT '0',
  `colornick`     VARCHAR(6)          NOT NULL,
  `colornick2`    VARCHAR(6)          NOT NULL,
  `statnik`       VARCHAR(6)          NOT NULL,
  `statnik2`      VARCHAR(6)          NOT NULL,
  `prosm_ank`     INT(11)             NOT NULL DEFAULT '0',
  `closed`        SET('0','1')        NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `my_guests`
--
DROP TABLE IF EXISTS `my_guests`;
CREATE TABLE IF NOT EXISTS `my_guests` (
  `id` int(11) NOT NULL auto_increment,
  `my_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `guest_id` int(11) NOT NULL,
  `type` set('0','1') NOT NULL default '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8; 
  
--
-- Структура таблицы `shop`
--
DROP TABLE IF EXISTS `shop`;
CREATE TABLE `shop` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `price` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `shop` (`id`, `price`) VALUES
(1,	10),
(2,	20),
(3,	30),
(4,	40),
(5,	20),
(6,	15),
(7,	15),
(8,	10),
(9,	5),
(10,	20),
(11,	10),
(12,	10),
(13,	30),
(14,	500),
(15,	1000),
(16,	1000);

--
-- Структура таблицы `lenta`
--
DROP TABLE IF EXISTS `lenta`;
CREATE TABLE IF NOT EXISTS `lenta` (
`id` 		INT(11) 	 	 NOT NULL AUTO_INCREMENT,
`id_user` 	INT(11)			 NOT NULL,
`id_kont` 	INT(11)			 NOT NULL,
`msg` 		VARCHAR(1024) 	 NOT NULL,
`read` 		SET('0','1') 	 NOT NULL DEFAULT '0',
`time` 		BIGINT(60) 		 NOT NULL,
`nima`	    VARCHAR(5000) 	 NOT NULL,
`nimaga`    VARCHAR(5000) 	 NOT NULL,
PRIMARY KEY (`id`),
KEY `id_user` (`id_user`,`id_kont`),
KEY `read` (`read`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Структура таблицы `yosh_status_klass`
--
DROP TABLE IF EXISTS `yosh_status_klass`;
CREATE TABLE IF NOT EXISTS `yosh_status_klass` (
  `id_rat` int(15) NOT NULL AUTO_INCREMENT,
  `kto` varchar(200) NOT NULL,
  `zakogo` varchar(200) NOT NULL,
  `type` varchar(20) NOT NULL,
  `komm` text NOT NULL,
  `date` bigint(60) NOT NULL,
  `ocenka` varchar(15) NOT NULL,
  `time` bigint(60) NOT NULL,
  KEY `id_rat` (`id_rat`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251;

--
-- Структура таблицы `yosh_status`
--
DROP TABLE IF EXISTS `yosh_status`;
CREATE TABLE IF NOT EXISTS `yosh_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(512) NOT NULL,
  `msg` varchar(5000) NOT NULL,
  `read` enum('0','1','2') NOT NULL,
  `write` enum('0','1','2') NOT NULL,
  `time` int(11) NOT NULL,
  `komm` int(11) DEFAULT '0',
  `look` int(11) DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `ajoyib` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Структура таблицы `yosh_status_komm`
--
DROP TABLE IF EXISTS `yosh_status_komm`;
CREATE TABLE IF NOT EXISTS `yosh_status_kom` (
  `id_kom` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(11) NOT NULL,
  `dater` varchar(30) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `id_kogo` int(11) NOT NULL,
  `type` varchar(40) NOT NULL,
  KEY `id_kom` (`id_kom`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251;

--
-- Структура таблицы `gifts`
--
DROP TABLE IF EXISTS `gifts`;
CREATE TABLE IF NOT EXISTS `gifts` (
 `id`    int(11)     NOT NULL AUTO_INCREMENT,
 `cat`   int(11)     NOT NULL DEFAULT '0',
 `type`  int(1)      NOT NULL DEFAULT '0',
 `name`  varchar(56) NOT NULL,
 `image` varchar(56) NOT NULL,
 `cost`  int(11)     NOT NULL DEFAULT '1',
 `pcost` int(11)     NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
--
-- Структура таблицы `users_gifts`
--
DROP TABLE IF EXISTS `users_gifts`;
CREATE TABLE IF NOT EXISTS `users_gifts` (
 `id`      int(11)      NOT NULL AUTO_INCREMENT,
 `user_id` int(11)      NOT NULL DEFAULT '7',
 `from_id` int(11)      NOT NULL DEFAULT '7',
 `name`    varchar(56)  NOT NULL,
 `image`   varchar(512) NOT NULL,
 `type`    int(1)       NOT NULL DEFAULT '0',
 `text`    varchar(256) NOT NULL,
 `time`    int(11)      NOT NULL,
PRIMARY KEY (`id`)
  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `sitesets`
--
DROP TABLE IF EXISTS `sitesets`;
CREATE TABLE `sitesets` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `value` varchar(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sitesets` (`id`, `value`) VALUES
(1,	25),
(2,	0),
(3,	0),
(4,	0),
(5,	10);

--
-- Структура таблицы `vip`
--
DROP TABLE IF EXISTS `vip`;

CREATE TABLE `vip`(
`id` int(11) NOT NULL AUTO_INCREMENT,
`user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
`from` varchar(25) NOT NULL DEFAULT '',
`t_id` int(11) NOT NULL,
`wagt` int(11) NOT NULL,
`time` int(11) NOT NULL,
PRIMARY KEY(`id`)
)ENGINE=MylSAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `niksalgy`
--
DROP TABLE IF EXISTS `niksalgy`;

CREATE TABLE `niksalgy` (
  `id`               int(5)   unsigned   NOT NULL AUTO_INCREMENT,
  `user_id`          int(5)              NOT NULL,
  `nik`            text                NOT NULL,
  `time`             int(11)             NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Структура таблицы `forum_group`
--
DROP TABLE IF EXISTS `forum_group`;

CREATE TABLE `forum_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oplata` varchar(244) DEFAULT '0',
  `user_id` varchar(10) NOT NULL,
  `status` varchar(244) NOT NULL,
  `img` varchar(244) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Структура таблицы `forum_group_add`
--
DROP TABLE IF EXISTS `forum_group_add`;

CREATE TABLE `forum_group_add` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(244) NOT NULL,
  `phone` varchar(10) NOT NULL,
  `group` varchar(244) NOT NULL,
  `wmid` varchar(244) NOT NULL,
  `wmr` varchar(244) NOT NULL,
  `wmz` varchar(244) NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Структура таблицы `forum_lenta`
--
CREATE TABLE IF NOT EXISTS `forum_lenta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_tema` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL,
  `ot_kogo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`ot_kogo`),
  KEY `read` (`read`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `forum_mavzu`
--
CREATE TABLE IF NOT EXISTS `forum_mavzu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(244) NOT NULL,
  `us` varchar(244) NOT NULL,
  `javob` varchar(244) NOT NULL,
  `user_id` varchar(10) DEFAULT '0',
  `kimga` varchar(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `forum_mehmon`
--
CREATE TABLE IF NOT EXISTS `forum_mehmon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ank` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- Структура таблицы `forum_rahmat`
--
CREATE TABLE IF NOT EXISTS `forum_rahmat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` varchar(255) DEFAULT NULL,
  `tema_id` varchar(10) DEFAULT '0',
  `user_id` varchar(10) DEFAULT '0',
  `us` varchar(244) NOT NULL,
  `kimga` varchar(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=1;

--
-- Структура таблицы `forum_reply`
--
CREATE TABLE IF NOT EXISTS `forum_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `mavzu` varchar(244) NOT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `forum_votte`
--
CREATE TABLE IF NOT EXISTS `forum_votte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` varchar(255) DEFAULT NULL,
  `tema_id` varchar(10) DEFAULT '0',
  `user_id` varchar(10) DEFAULT '0',
  `us` varchar(244) NOT NULL,
  `kimga` varchar(10) DEFAULT '0',
  `votte` varchar(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `forum_zaklad`
--
CREATE TABLE IF NOT EXISTS `forum_zaklad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(244) NOT NULL,
  `us` varchar(244) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `awards`
--
DROP TABLE IF EXISTS `awards`;

CREATE TABLE IF NOT EXISTS `awards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `desc` varchar(150) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `img` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Структура таблицы `award_users`
--
DROP TABLE IF EXISTS `award_users`;

CREATE TABLE IF NOT EXISTS `award_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_award` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_who` int(11) NOT NULL,
  `from` VARCHAR(25) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Структура таблицы `medals`
--
DROP TABLE IF EXISTS `medals`;

CREATE TABLE IF NOT EXISTS `medals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `desc` varchar(150) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `img` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Структура таблицы `medal_users`
--
DROP TABLE IF EXISTS `medal_users`;

CREATE TABLE IF NOT EXISTS `medal_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_medal` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_who` int(11) NOT NULL,
  `from` VARCHAR(25) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `m_chat`;
CREATE TABLE `m_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `fayl1` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;


DROP TABLE IF EXISTS `m_chat1`;
CREATE TABLE `m_chat1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `forum_okaldy`
--
CREATE TABLE IF NOT EXISTS `forum_okaldy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(244) NOT NULL,
  `us` varchar(244) NOT NULL,
  `javob` varchar(244) NOT NULL,
  `user_id` varchar(10) DEFAULT '0',
  `kimga` varchar(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


--
-- Структура таблицы `vip_movzuk`
--
DROP TABLE IF EXISTS `vip_movzuk`;

CREATE TABLE `vip_movzuk`(
`id` int(11) NOT NULL AUTO_INCREMENT,
`user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
`from` varchar(25) NOT NULL DEFAULT '',
`m_id` int(11) NOT NULL,
`wagt` int(11) NOT NULL,
`time` int(11) NOT NULL,
PRIMARY KEY(`id`)
)ENGINE=MylSAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `vip_mowzuk`
--
DROP TABLE IF EXISTS `vip_mowzuk`;

CREATE TABLE `vip_mowzuk`(
`id` int(11) NOT NULL AUTO_INCREMENT,
`user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
`from` varchar(25) NOT NULL DEFAULT '',
`mow_id` int(11) NOT NULL,
`wagt` int(11) NOT NULL,
`time` int(11) NOT NULL,
PRIMARY KEY(`id`)
)ENGINE=MylSAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `forum2`
--
DROP TABLE IF EXISTS `forum2`;
CREATE TABLE `forum2` (
  `id`           INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `type`         CHAR(1)          NOT NULL DEFAULT '',
  `time`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time2`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `from`         VARCHAR(25)      NOT NULL DEFAULT '',
  `realid`       INT(3)           NOT NULL DEFAULT '0',
  `like`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ip`           BIGINT(11)       NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)       NOT NULL DEFAULT '0',
  `soft`         TEXT             NOT NULL,
  `text`         TEXT             NOT NULL,
  `close`        TINYINT(1)       NOT NULL DEFAULT '0',
  `close_who`    VARCHAR(25)      NOT NULL DEFAULT '',
  `vip`          TINYINT(1)       NOT NULL DEFAULT '0',
  `okaldy`       int(11)                   DEFAULT '0',
  `m_ok`         int(10) unsigned NOT NULL DEFAULT '0',
  `edit`         TEXT             NOT NULL,
  `moway`        INT(2)              NOT NULL DEFAULT '0',
  `mowsene`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `tedit`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `kedit`        INT(2) UNSIGNED  NOT NULL DEFAULT '0',
  `curators`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `user_yzarla`
--
DROP TABLE IF EXISTS `user_yzarla`;

CREATE TABLE IF NOT EXISTS `user_yzarla` (
  `l_id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `user_id` VARCHAR(25)  NOT NULL DEFAULT '',
  `to` int(11) NOT NULL,
  `l_time` int(11) NOT NULL,
  `preg` int(1) NOT NULL DEFAULT '0',
  `desc` varchar(2) NOT NULL,
  PRIMARY KEY (`l_id`),
  KEY `user` (`user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=76 ;

--
-- Структура таблицы `gymyldy`
--
DROP TABLE IF EXISTS `gymyldy`;
CREATE TABLE IF NOT EXISTS `gymyldy` (
  `id`        INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `from_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `text`      TEXT                NOT NULL,
  `from`      VARCHAR(25)         NOT NULL DEFAULT '',
  `time`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `read`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `sys`       TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `delete`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `file_name` VARCHAR(100)        NOT NULL DEFAULT '',
  `count`     INT(10)             NOT NULL DEFAULT '0',
  `size`      INT(10)             NOT NULL DEFAULT '0',
  `them`      VARCHAR(100)        NOT NULL DEFAULT '',
  `spam`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `haryt`
--
DROP TABLE IF EXISTS `haryt`;

CREATE TABLE `haryt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `from` varchar(25) NOT NULL DEFAULT '',
  `doly` TEXT NOT NULL,
  `saher` VARCHAR(100) NOT NULL DEFAULT '',
  `baglan` varchar(13) NOT NULL DEFAULT '',
  `barada` varchar(5000) NOT NULL DEFAULT '',
  `user` int(11) NOT NULL DEFAULT '0',
  `time` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `plus` int(11) NOT NULL DEFAULT '0',
  `minus` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Структура таблицы `haryt_goruldi`
--
CREATE TABLE IF NOT EXISTS `haryt_goruldi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(244) NOT NULL,
  `us` varchar(244) NOT NULL,
  `javob` varchar(244) NOT NULL,
  `user_id` varchar(10) DEFAULT '0',
  `kimga` varchar(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- Структура таблицы `haryt_komm`
--
DROP TABLE IF EXISTS `haryt_komm`;

CREATE TABLE `haryt_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `komm` varchar(500) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Структура таблицы `haryt_vote`
--
DROP TABLE IF EXISTS `haryt_vote`;

CREATE TABLE `haryt_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `count` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Структура таблицы `goreldeli`
--
CREATE TABLE IF NOT EXISTS `goreldeli` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `hasap`
--
DROP TABLE IF EXISTS `hasap`;

CREATE TABLE `hasap`(
`id` int(11) NOT NULL AUTO_INCREMENT,
`user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
`hasap` int(11) NOT NULL DEFAULT '0',
`wagt` int(11) NOT NULL,
PRIMARY KEY(`id`)
)ENGINE=MylSAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `degishgen`
--
DROP TABLE IF EXISTS `degishgen`;

CREATE TABLE `degishgen`(
`id` int(11) NOT NULL AUTO_INCREMENT,
`tekst` text NOT NULL,
`gyz` text NOT NULL,
`oglan` text NOT NULL,
`aktiv` int(10) UNSIGNED NOT NULL DEFAULT '0',
PRIMARY KEY(`id`)
)ENGINE=MylSAM DEFAULT CHARSET=utf8mb4;


