<?php


define('_IN_JOHNCMS', 1);

$textl = ' WHOIS servisi ';

$rootpath = '../../';

require_once ("../../incfiles/core.php");

require_once ("../../incfiles/head.php");

header("Content-type:text/html; charset=utf-8");

echo '<div class="phdr"><b> WHOIS servisi </b></div>';

$Debug = 0;

$Servers = array(
/* The program looks for the first match in this table, so these
must be listed *before* the others. Generally these domainnames
are offerred by a registrar that has some interesting top-level
domainnames and sells sub-domainnames. */
array(".*\.au\.com$","whois.au.com"),
array(".*\.ac\.uk$","whois.ja.net"),
array(".*\.eu\.org$","whois.eu.org"),
array(".*\.gov\.uk$","whois.ja.net"),

/* Domain names by CentralNic. */
array(".*\.ae\.org$","whois.centralnic.com"),
array(".*\.br\.com$","whois.centralnic.com"),
array(".*\.cn\.com$","whois.centralnic.com"),
array(".*\.de\.com$","whois.centralnic.com"),
array(".*\.eu\.com$","whois.centralnic.com"),
array(".*\.gb\.com$","whois.centralnic.com"),
array(".*\.gb\.net$","whois.centralnic.com"),
array(".*\.hu\.com$","whois.centralnic.com"),
array(".*\.jpn\.com$","whois.centralnic.com"),
array(".*\.kr\.com$","whois.centralnic.com"),
array(".*\.no\.com$","whois.centralnic.com"),
array(".*\.qc\.com$","whois.centralnic.com"),
array(".*\.ru\.com$","whois.centralnic.com"),
array(".*\.sa\.com$","whois.centralnic.com"),
array(".*\.se\.com$","whois.centralnic.com"),
array(".*\.se\.net$","whois.centralnic.com"),
array(".*\.uk\.com$","whois.centralnic.com"),
array(".*\.uk\.net$","whois.centralnic.com"),
array(".*\.us\.com$","whois.centralnic.com"),
array(".*\.uy\.com$","whois.centralnic.com"),
array(".*\.web\.com$","whois.centralnic.com"),
array(".*\.za\.com$","whois.centralnic.com"),

/* Not all countries have a whois server. A good place to look is:
http://www.iana.org/cctld/cctld-whois.htm
*/
array(".*\.ac$","whois.nic.ac"),
array(".*\.ag$","whois.nic.ag"),
array(".*\.am$","whois.amnic.net"),
array(".*\.as$","whois.nic.as"),
array(".*\.at$","whois.nic.at"),
array(".*\.au$","whois.aunic.net"),
array(".*\.be$","whois.dns.be"),
array(".*\.br$","whois.registro.br"),
array(".*\.bz$","whois.belizenic.bz"),
array(".*\.ca$","whois.cira.ca"),
array(".*\.cc$","whois.nic.cc"),
  array(".*\.ch$","whois.nic.ch"),

  array(".*\.ck$","whois.ck-nic.org.ck"),

  array(".*\.cl$","whois.nic.cl"),

  array(".*\.cn$","whois.cnnic.net.cn"),

  array(".*\.cx$","whois.nic.cx"),

  array(".*\.cz$","whois.nic.cz"),

  array(".*\.de$","whois.denic.de"),

  array(".*\.dk$","whois.dk-hostmaster.dk"),

  array(".*\.ee$","whois.eenet.ee"),

  array(".*\.eu$","whois.eu"),

  array(".*\.fr$","whois.nic.fr"),

  array(".*\.gg$","whois.isles.net"),

  array(".*\.gs$","whois.adamsnames.tc"),

  array(".*\.hk$","whois.hkirc.net.hk"),

  array(".*\.hm$","whois.registry.hm"),

  array(".*\.hu$","whois.nic.hu"),

  array(".*\.id$","whois.idnic.net.id"),

  array(".*\.ie$","whois.domainregistry.ie"),

  array(".*\.il$","whois.isoc.org.il"),

  array(".*\.in$","whois.ncst.ernet.in"),

  array(".*\.io$","whois.nic.io"),

  array(".*\.ir$","whois.nic.ir"),

  array(".*\.is$","whois.isnet.is"),

  array(".*\.it$","whois.nic.it"),

  array(".*\.je$","whois.isles.net"),

  array(".*\.jp$","whois.jprs.jp"),

  array(".*\.ke$","whois.kenic.or.ke"),

  array(".*\.kr$","whois.nic.or.kr"),

  array(".*\.la$","whois.afilias-grs.net"),

  array(".*\.li$","whois.nic.li"),

//  array(".*\.lk$","whois.nic.lk"),            /* Gives an MySQL error? */

  array(".*\.lt$","whois.domreg.lt"),

  array(".*\.lu$","whois.dns.lu"),

  array(".*\.lv$","whois.nic.lv"),

  array(".*\.mn$","whois.nic.mn"),

  array(".*\.ms$","whois.adamsnames.tc"),

  array(".*\.mx$","whois.nic.mx"),

  array(".*\.nl$","whois.domain-registry.nl"),

  array(".*\.no$","whois.norid.no"),

  array(".*\.nu$","whois.nic.nu"),

  array(".*\.nz$","whois.srs.net.nz"),

  array(".*\.pl$","whois.dns.pl"),

  array(".*\.re$","whois.nic.re"),

  array(".*\.ro$","whois.rotld.ro"),

  array(".*\.ru$","whois.ripn.net"),

  array(".*\.se$","whois.nic-se.se"),

  array(".*\.sg$","whois.nic.net.sg"),

  array(".*\.sh$","whois.nic.sh"),

  array(".*\.si$","whois.arnes.si"),

  array(".*\.st$","whois.nic.st"),

  array(".*\.tc$","whois.adamsnames.tc"),

  array(".*\.tf$","whois.nic.tf"),

  array(".*\.th$","whois.thnic.net"),

  array(".*\.tk$","whois.dot.tk"),

  array(".*\.tm$","whois.nic.tm"),

  array(".*\.to$","whois.tonic.to"),

  array(".*\.tr$","whois.nic.tr"),

  array(".*\.tv$","whois.nic.tv"),

  array(".*\.tw$","whois.twnic.net"),

  array(".*\.ua$","whois.net.ua"),

  array(".*\.ug$","whois.co.ug"),

  array(".*\.uk$","whois.nic.uk"),

  array(".*\.us$","whois.nic.us"),

  array(".*\.vg$","whois.adamsnames.tc"),

  array(".*\.ws$","whois.worldsite.ws"),



  array(".*\.aero$","whois.information.aero"),

  array(".*\.biz$","whois.neulevel.biz"),

  array(".*\.com$","whois.internic.net"),

  array(".*\.coop$","whois.nic.coop"),

  array(".*\.edu$","whois.internic.net"),

  array(".*\.gov$","whois.nic.gov"),

  array(".*\.info$","whois.afilias.info"),

  array(".*\.int$","whois.iana.org"),

  array(".*\.mil$","whois.nic.mil"),

  array(".*\.museum$","whois.museum"),

  array(".*\.name$","whois.nic.name"),

  array(".*\.net$","whois.internic.net"),

  array(".*\.org$","whois.publicinterestregistry.net"),

  );







/* Send a query to a Whois server and return the reply. */

function RawWhois($Query,$Server,$Debug) {



  /* Split the port from the Server. */

  $a = explode(":",$Server);

  if ($a[1] > 0) {

      $Port = $a[1];

      $Server = $a[0];

    } else {

      $Port = 43;

      }



  /* Translate the Server into an ip-address, if it's not an ip-address

     already. */

  $a = explode(".",$Server);

  if (($a[0] > 0) && ($a[0] < 256) && ($a[3] > 0) && ($a[3] < 256)) {

      $ServerIP = $Server;

    } else {

      $ServerIP = @gethostbyname($Server);

      }



  /* Open connection to the Server. */

  $Socket = @fsockopen($ServerIP,$Port,$errno,$errstr);

  if ($Socket == FALSE) {

    if ($Debug > 0) {

      echo 'Cannot connect to server:<br>' . $errno . ' ' . $errstr . '' . "\n";

      }

    return('');

    }



  /* Send query to the server. */

  if ($Debug != 0) echo '<pre>' . $Query . '</pre>';

  if (fputs($Socket,$Query . "\r\n") == FALSE) {

    fclose($Socket);

    if ($Debug > 0) {

      echo 'Error sending query:<br><pre>' . $Query . '</pre>' . "\n";

      }

    return('');

    }



  /* Collect reply from the server. */

  $Reply = '';

  while (TRUE) {

    $Result = fread($Socket,1000000);

    if ($Result == FALSE) break;

    $Reply = $Reply . $Result;

    }



  /* Close the connection. */

  fclose($Socket);



  /* Show message if no reply was received. */

  if (($Debug > 0) && ($Reply == '')) {

    echo 'No reply received.' . "\n";

    }



  /* Return the reply. */

  return($Reply);

  }







function getmicrotime() {

  list($usec, $sec) = explode(" ",microtime());

  return((float)$usec + (float)$sec);

  }











/* Translate IDN domainnames into their ASCII equivalent. For example

   'frии.com' becomes 'xn--fr-8iaa.com'. The translation uses the

   Net_IDNA library by PHlyLabs, see http://phlymail.de/en/downloads/idna/

   */

$Domain = @$HTTP_GET_VARS['Domain'];

if ((! isset($Domain)) || ($Domain == '')) $Domain = @$_GET['Domain'];

if ($Domain != '') {

  include('idna_convert.class.php');

  $IDN = new idna_convert();

  $Domain = $IDN->encode($Domain);

  }



/* Cleanup the Domain. */

$Domain = ereg_replace("[^-[:alnum:]_.!@=*+/]","",strtolower($Domain));

$Url = parse_url($Domain);

if (($Url !== FALSE) && ($Url["host"] != '')) $Domain = $Url["host"];

if (strncmp($Domain,"www.",4) == 0) $Domain = substr($Domain,4);



/* Cleanup the Server. */

$Server = @$HTTP_GET_VARS['Server'];

if ((! isset($Server)) || ($Server == '')) $Server = @$_GET['Server'];

$Server = ereg_replace("[^-[:alnum:]_.!@=*+/]","",strtolower($Server));

$Url = parse_url($Server);

if (($Url !== FALSE) && ($Url["host"] != '')) $Server = $Url["host"];

if ((! isset($Server)) || ($Server == '')) $Server = '--automatic--';



/* Show the form asking for a domainname or ipaddress. */

echo '<div class="menu"><table cellspacing=0 cellpadding=10>' . "\n";

echo '<form action="' . $_SERVER['SCRIPT_NAME'] . '" method=get>' . "\n";

echo '<tr>' . "\n";

echo '  <td>' . "\n";

echo '    Domenni kiriting. (Masalan: soyabon.ru): <br />' . "\n";
echo '    <input type=text size=20 name=Domain value="' . htmlentities($Domain) . '">' . "\n";

echo '    <br /><br /><input type=submit value=" Tekshirish ">' . "\n";
echo '    </td>' . "\n";

echo '  </tr>' . "\n";

echo '</form>' . "\n";

echo '</table></div>' . "\n";





/* Perform the Whois query. */

if ($Domain != '') {



  /* If no server was specified then automatically determine. */

  if ($Server == '--automatic--') {

    $Server = 'whois.internic.net';

    $a = explode(".",$Domain);

    if (($a[0] > 0) && ($a[0] < 256) && ($a[3] > 0) && ($a[3] < 256)) {

      $Server = 'whois.arin.net';

      }

    for ($i = 0; $i < sizeof($Servers); $i++) {

      if (ereg($Servers[$i][0],$Domain,$a)) {

        $Server = $Servers[$i][1];

        break;

        }

      }

    }



  /* Send the query to the server. */

echo '<div class="menu"><p>Sizning domeningiz "' . htmlentities($Domain) . '" serveri "' .
    htmlentities($Server) . '":<br>' . "\n";

  $time_start = getmicrotime();

  $Raw = RawWhois($Domain,$Server,$Debug);

  $time_end = getmicrotime();

  echo strlen($Raw) . ' bytes, ' . ($time_end - $time_start) . ' seconds</p></div>' . "\n";



  /* Scan the answer for a redirect. If found then send the query again

     to the server named in the redirect. */

  $Redirect = '';

if (stristr($Raw,'Asia Pacific Network Information Center ') !== FALSE) {
$Redirect = 'whois.apnic.net';
}
if ((stristr($Raw,'European Regional Internet Registry/RIPE NCC') !== FALSE) ||
(stristr($Raw,'Allocated to RIPE NCC') !== FALSE)) {
$Redirect = 'whois.ripe.net';
}
if (ereg("   Whois Server: ([0-9A-Za-z\._-]*)",$Raw,$a)) {
$Redirect = $a[1];
}
if (ereg("ReferralServer: ([0-9A-Za-z\._/:-]*)",$Raw,$a)) {
$Redirect = $a[1];
if (substr($Redirect,0,8) == 'whois://') $Redirect = substr($Redirect,8);
}
if ($Redirect != '') {
echo '<div class="menu"><p>Переадресовано на: ' . $Redirect . '</p></div>' . "\n";
$RawOriginal = $Raw;
echo '<div class="menu"><p>Отправка запроса "' . $Domain . '" на сервер "' . $Redirect . '":<br>' . "\n";
$time_start = getmicrotime();
$Raw = RawWhois($Domain,$Redirect,$Debug);
$time_end = getmicrotime();
echo strlen($Raw) . ' bytes, ' . ($time_end - $time_start) . ' seconds</p></div>' . "\n";
}


/* Show the answer. */
echo '<div class="menu"><table cellspacing=0 cellpadding=10 width="100%">' . "\n";
echo '<tr>' . "\n";
echo '  <td>' . "\n";
echo '    <pre>';
echo htmlspecialchars(trim($Raw),ENT_QUOTES);
echo '</pre>' . "\n";
echo '    </td>' . "\n";
echo '  </tr>' . "\n";
echo '</table></div>' . "\n";

/* If the query was redirected then show the original answer. */
if (isset($RawOriginal)) {
echo '<div class="menu">Original reply from "' . $Server . '":<br><br>' . "\n";
echo '<table cellspacing=0 cellpadding=10 width="100%">' . "\n";
echo '<tr>' . "\n";
echo '  <td>' . "\n";
echo '    <pre>';
echo htmlspecialchars(trim($RawOriginal),ENT_QUOTES);
echo '</pre>' . "\n";
echo '    </td>' . "\n";
echo '  </tr>' . "\n";
echo '</table></div>' . "\n";
}
}


require_once ("../../incfiles/end.php");

?>

