<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

defined('_IN_JOHNCMS') or die('Restricted access');

class comments
{
    // Служебные данные
    private $object_table;                                // Таблица комментируемых объектов
    private $comments_table;                              // Таблица с комментариями
    private $sub_id = false;                              // Идентификатор комментируемого объекта
    private $item;                                        // Локальный идентификатор
    private $user_id = false;                             // Идентификатор авторизованного пользователя
    private $owner = false;
    private $rights = 0;                                  // Права доступа
    private $ban = false;                                 // Находится ли юзер в бане?
    private $url;                                         // URL формируемых ссылок

    // Права доступа
    private $access_delete = false;                       // Возможность удалять комментарий
    private $access_level = 6;                            // Уровень доступа для Администрации

    // Параметры отображения комментариев
    public $min_lenght = 3;                               // Мин. к-во символов в комментарии
    public $max_lenght = 5000;                            // Макс. к-во символов в комментарии

    // Возвращаемые значения
    public $total = 0;                                    // Общее число комментариев объекта
    public $added = false;                                // Метка добавления нового комментария

    /*
    -----------------------------------------------------------------
    Конструктор класса
    -----------------------------------------------------------------
    */
    function __construct($arg = array())
    {
        global $mod, $start, $kmess;
        $this->comments_table = $arg['comments_table'];
        $this->object_table = !empty($arg['object_table']) ? $arg['object_table'] : false;
        if (!empty($arg['sub_id_name']) && !empty($arg['sub_id'])) {
            $this->sub_id = $arg['sub_id'];
            $this->url = $arg['script'] . '&amp;' . $arg['sub_id_name'] . '=' . $arg['sub_id'];
        } else {
            $this->url = $arg['script'];
        }
        $this->item = isset($_GET['item']) ? abs(intval($_GET['item'])) : false;
        // Получаем данные пользователя
        if (core::$user_id) {
            $this->user_id = core::$user_id;
            $this->rights = core::$user_rights;
            $this->ban = core::$user_ban;
        }
        // Назначение пользовательских прав
        if (isset($arg['owner'])) {
            $this->owner = $arg['owner'];
            if (core::$user_id && $arg['owner'] == core::$user_id && !$this->ban) {
                $this->access_delete = isset($arg['owner_delete']) ? $arg['owner_delete'] : false;
            }
        }
        // Открываем доступ для Администрации
        if ($this->rights >= $this->access_level) {
            $this->access_delete = true;
        }

        switch ($mod) {
            case 'del':
                /*
                -----------------------------------------------------------------
                Удаляем комментарий
                -----------------------------------------------------------------
                */
                if ($this->item && $this->access_delete && !$this->ban) {
                    if (isset($_GET['yes'])) {
                        $req = mysql_query("SELECT * FROM `" . $this->comments_table . "` WHERE `id` = '" . $this->item . "' AND `sub_id` = '" . $this->sub_id . "' LIMIT 1");
                        if (mysql_num_rows($req)) {
                            $res = mysql_fetch_assoc($req);
                            if (isset($_GET['all'])) {
                                // Удаляем все комментарии выбранного пользователя
                                $count = mysql_result(mysql_query("SELECT COUNT(*) FROM `" . $this->comments_table . "` WHERE `sub_id` = '" . $this->sub_id . "' AND `user_id` = '" . $res['user_id'] . "'"), 0);
                                mysql_query("DELETE FROM `" . $this->comments_table . "` WHERE `sub_id` = '" . $this->sub_id . "' AND `user_id` = '" . $res['user_id'] . "'");
                            } else {
                                // Удаляем отдельный комментарий
                                $count = 1;
                                mysql_query("DELETE FROM `" . $this->comments_table . "` WHERE `id` = '" . $this->item . "'");
                            }
                            // Вычитаем баллы из статистики пользователя
                            $req_u = mysql_query("SELECT * FROM `users` WHERE `id` = '" . $res['user_id'] . "'");
                            if (mysql_num_rows($req_u)) {
                                $res_u = mysql_fetch_assoc($req_u);
                                $count = $res_u['komm'] > $count ? $res_u['komm'] - $count : 0;
                                mysql_query("UPDATE `users` SET `komm` = '$count' WHERE `id` = '" . $res['user_id'] . "'");
                            }
                            // Обновляем счетчик комментариев
                            $this->msg_total(1);
                        }
                        header('Location: ' . str_replace('&amp;', '&', $this->url));
                    } else {
                        echo '<div class="rmenu"><p>' . core::$lng['delete_confirmation'] . '<br />' .
                             '<a href="' . $this->url . '&amp;mod=del&amp;item=' . $this->item . '&amp;yes">' . core::$lng['delete'] . '</a> | ' .
                             '<a href="' . $this->url . '">' . core::$lng['cancel'] . '</a></p></div>' .
                             '<div class="phdr"><a href="' . $this->url . '">' . core::$lng['back'] . '</a></div>';
                    }
                }
                break;

            default:
                if (!empty($arg['context_top']))
                    echo $arg['context_top'];

                /*
                -----------------------------------------------------------------
                Добавляем новый комментарий
                -----------------------------------------------------------------
                */
                if(!$this->ban  && !functions::is_ignor($this->owner) && isset($_POST['submit']) && ($message = $this->msg_check(1)) !== false){
                    if (empty($message['error'])) {
                        // Записываем комментарий в базу
                        $this->add_comment($message['text']);
                        $this->total = $this->msg_total(1);
                        $_SESSION['code'] = $message['code'];
                    } else {
                        // Показываем ошибки, если есть
                        echo functions::display_error($message['error']);
                        $this->total = $this->msg_total();
                    }
                } else {
                    $this->total = $this->msg_total();
                }

                /*
                -----------------------------------------------------------------
                Показываем форму ввода
                -----------------------------------------------------------------
                */
                if (!$this->ban && !functions::is_ignor($this->owner)) {
                    echo $this->msg_form();
                }

                /*
                -----------------------------------------------------------------
                Показываем список комментариев
                -----------------------------------------------------------------
                */
                echo '<div class="phdr"><b>' . $arg['title'] . '</b></div>';
                if ($this->total) {
                    $req = mysql_query("SELECT `" . $this->comments_table . "`.*, `" . $this->comments_table . "`.`id` AS `subid`, `users`.`rights`, `users`.`dayb`, `users`.`monthb`, `users`.`sestime`, `users`.`sex`, `users`.`lastdate`, `users`.`imname`, `users`.`datereg`, `users`.`id`
                    FROM `" . $this->comments_table . "` LEFT JOIN `users` ON `" . $this->comments_table . "`.`user_id` = `users`.`id`
                    WHERE `sub_id` = '" . $this->sub_id . "' ORDER BY `subid` DESC LIMIT $start, $kmess");
                    while (($res = mysql_fetch_assoc($req)) !== false) {
					    echo '<div class="menu">';
						if (file_exists('../files/users/photo/' . $res['id'] . '_small.jpg'))
							echo '<img class="avatar" src="'.$home.'/files/users/photo/' . $res['id'] . '_small.jpg" alt="#"/>';
                	else if (mb_strlen($res['imname']) > 1) {
			        	$text = mb_substr($res['imname'], 0, 1);
						echo '<div class="avatar-'.$text.'"><h3>'.$text.'</h3></div>';
                	}
					echo '<div style="min-height: 52px; margin-left: 54px;">';
					if ($res['dayb'] == date('j', time()) && $res['monthb'] == date('n', time()))
					echo functions::image('birthday.png');
					
					if ($res['sex']){
					$rank = array(
						0 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off' : '-on') . '.png') . '',
               			1 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		2 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		3 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		4 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		5 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		6 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-moder' : '-on-moder') . '.png') . '',
                		7 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-admin' : '-on-admin') . '.png') . '',
                		9 => '' . functions::image(($res['sex'] == 'm' ? 'm' : 'w') . (time() > $res['lastdate'] + 300 ? '-off-admin' : '-on-admin') . '.png') . ''
            		);
						echo $rank[$res['rights']];
					} else {
						echo functions::image('user-delete.png');
					}
					
					echo '<a href="' . $home . '/users/profile.php?user=' . $res['id'] . '"><b>' . $res['imname'] . '</b></a>&#160;';
            		echo (time() > $res['lastdate'] + 300 ? '' : '<span class="green"> [' . functions::usertimecount(time() - $res['sestime']) . ']</span>');
					
                    $text = functions::checkout($res['text'], 1, 1);
                    if (core::$user_set['smileys'])
                        $text = functions::smileys($text);
					echo '<br/>'.$text.'</div><br/>';
					echo '<div style="font-size: 12px; color: #999999; float: left;">' . functions::display_date($res['time']) . '</div>';
					echo '<div style="font-size: 12px; float: right;">';
					if ($this->access_delete) echo '<a href="' . $this->url . '&amp;mod=del&amp;item=' . $res['subid'] . '">' . core::$lng['delete'] . '</a>';
					echo '</div>';
					echo '<div style="clear: both;"></div></div>';
                    }
                } else {
                    echo '<div class="menu"><p>' . core::$lng['list_empty'] . '</p></div>';
                }
                echo '<div class="phdr">' . core::$lng['total'] . ': ' . $this->total . '</div>';
                if ($this->total > $kmess) {
                    echo '<div class="topmenu">' . functions::display_pagination($this->url . '&amp;', $start, $this->total, $kmess) . '</div>';
                }
                if (!empty($arg['context_bottom']))
                    echo $arg['context_bottom'];
        }
    }

    /*
    -----------------------------------------------------------------
    Добавляем комментарий в базу
    -----------------------------------------------------------------
    */
    private function add_comment($message)
    {
        // Записываем комментарий в базу
        mysql_query("INSERT INTO `" . $this->comments_table . "` SET
            `sub_id` = '" . intval($this->sub_id) . "',
            `user_id` = '" . $this->user_id . "',
            `text` = '" . mysql_real_escape_string($message) . "',
            `time` = '" . time() . "',
            `attributes` = '" . mysql_real_escape_string(serialize($attributes)) . "'
        ");
        // Обновляем статистику пользователя
        mysql_query("UPDATE `users` SET `komm` = '" . (++core::$user_data['komm']) . "', `lastpost` = '" . time() . "' WHERE `id` = '" . $this->user_id . "'");
        if($this->owner && $this->user_id == $this->owner){
            mysql_query("UPDATE `users` SET `comm_old` = '" . (core::$user_data['komm']) . "' WHERE `id` = '" . $this->user_id . "'");
        }
        $this->added = true;
    }

    /*
    -----------------------------------------------------------------
    Форма ввода комментария
    -----------------------------------------------------------------
    */
    private function msg_form($submit_link = '', $text = '')
    {
        return '<div class="menu"><form name="form" action="' . $this->url . $submit_link . '" method="post"><p>' .
               (!empty($text) ? '<div class="quote">' . $text . '</div></p><p>' : '') .
               '<b>' . core::$lng['message'] . '</b>: <small>(Maksimal: ' . $this->max_lenght . ')</small><br />' .
               '</p><p>' . bbcode::auto_smileys('form', 'message') .
               '<textarea rows="' . core::$user_set['field_h'] . '" name="message">' . $reply . '</textarea><br/>' .
               '<input type="hidden" name="code" value="' . rand(1000, 9999) . '" /><input type="submit" name="submit" value="' . core::$lng['sent'] . '"/></p></form></div>';
    }

    /*
    -----------------------------------------------------------------
    Проверка текста сообщения
    -----------------------------------------------------------------
    $rpt_check (boolean)    проверка на повтор сообщений
    -----------------------------------------------------------------
    */
    private function msg_check($rpt_check = false)
    {
        $error = array();
        $message = isset($_POST['message']) ? mb_substr(trim($_POST['message']), 0, $this->max_lenght) : false;
        $code = isset($_POST['code']) ? intval($_POST['code']) : NULL;
        $code_chk = isset($_SESSION['code']) ? $_SESSION['code'] : NULL;
        // Проверяем код
        if($code == $code_chk) return false;
		// avtoban
		include ('../incfiles/bancomm.php');
        // Проверяем на минимально допустимую длину
        if (mb_strlen($message) < $this->min_lenght) {
            $error[] = core::$lng['error_message_short'];
        } else {
            // Проверка на флуд
            $flood = functions::antiflood();
            if ($flood)
                $error[] = core::$lng['error_flood'] . ' ' . $flood . '&#160;' . core::$lng['seconds'];
        }
        // Проверка на повтор сообщений
        if (!$error && $rpt_check) {
            $req = mysql_query("SELECT * FROM `" . $this->comments_table . "` WHERE `user_id` = '" . $this->user_id . "' ORDER BY `id` DESC LIMIT 1");
            $res = mysql_fetch_assoc($req);
            if (mb_strtolower($message) == mb_strtolower($res['text']))
                $error[] = core::$lng['error_message_exists'];
        }
        // Возвращаем результат
        return array(
            'code' => $code,
            'text' => $message,
            'error' => $error
        );
    }

    /*
    -----------------------------------------------------------------
    Счетчик комментариев
    -----------------------------------------------------------------
    */
    private function msg_total($update = false)
    {
        $total = mysql_result(mysql_query("SELECT COUNT(*) FROM `" . $this->comments_table . "` WHERE `sub_id` = '" . $this->sub_id . "'"), 0);
        if ($update) {
            // Обновляем счетчики в таблице объекта
            mysql_query("UPDATE `" . $this->object_table . "` SET `comm_count` = '$total' WHERE `id` = '" . $this->sub_id . "'");
        }
        return $total;
    }
}