
--
-- Структура таблицы `adminchat`
--

CREATE TABLE IF NOT EXISTS `adminchat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- Структура таблицы `chat`
--

CREATE TABLE IF NOT EXISTS `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


--
-- Структура таблицы `cms_ads`
--

CREATE TABLE IF NOT EXISTS `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `layout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `count_link` int(10) unsigned NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) unsigned NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` int(10) unsigned NOT NULL DEFAULT '0',
  `mesto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cms_ban_ip`
--

CREATE TABLE IF NOT EXISTS `cms_ban_ip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` bigint(11) NOT NULL DEFAULT '0',
  `ip2` bigint(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '0',
  `link` varchar(100) NOT NULL,
  `who` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cms_ban_users`
--

CREATE TABLE IF NOT EXISTS `cms_ban_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ban_time` int(11) NOT NULL DEFAULT '0',
  `ban_while` int(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '1',
  `ban_who` varchar(30) NOT NULL DEFAULT '',
  `ban_ref` int(11) NOT NULL DEFAULT '0',
  `ban_reason` text NOT NULL,
  `ban_raz` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


--
-- Структура таблицы `cms_contact`
--

CREATE TABLE IF NOT EXISTS `cms_contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friends` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `man` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`,`from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- Структура таблицы `cms_counters`
--

CREATE TABLE IF NOT EXISTS `cms_counters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(10) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `link1` text NOT NULL,
  `link2` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '1',
  `switch` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


--
-- Структура таблицы `cms_forum_files`
--

CREATE TABLE IF NOT EXISTS `cms_forum_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) unsigned NOT NULL DEFAULT '0',
  `subcat` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `post` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `filename` text NOT NULL,
  `filetype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dlcount` int(10) unsigned NOT NULL DEFAULT '0',
  `del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cms_forum_rdm`
--

CREATE TABLE IF NOT EXISTS `cms_forum_rdm` (
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Дамп данных таблицы `cms_forum_rdm`
--

INSERT INTO `cms_forum_rdm` (`topic_id`, `user_id`, `time`) VALUES
(24, 1, 1472647906);

-- --------------------------------------------------------

--
-- Структура таблицы `cms_forum_vote`
--

CREATE TABLE IF NOT EXISTS `cms_forum_vote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `cms_forum_vote_users`
--

CREATE TABLE IF NOT EXISTS `cms_forum_vote_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `cms_mail`
--

CREATE TABLE IF NOT EXISTS `cms_mail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sys` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `delete` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name` varchar(100) NOT NULL DEFAULT '',
  `count` int(10) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `them` varchar(100) NOT NULL DEFAULT '',
  `spam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


--
-- Структура таблицы `cms_news_comments`
--

CREATE TABLE IF NOT EXISTS `cms_news_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `text` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `cms_sessions`
--

CREATE TABLE IF NOT EXISTS `cms_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` smallint(5) unsigned NOT NULL DEFAULT '0',
  `place` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cms_settings`
--

CREATE TABLE IF NOT EXISTS `cms_settings` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Дамп данных таблицы `cms_settings`
--

INSERT INTO `cms_settings` (`key`, `val`) VALUES
  ('active', '1'),
  ('admp', 'panel'),
  ('antiflood', 'a:5:{s:4:"mode";i:2;s:3:"day";i:10;s:5:"night";i:30;s:7:"dayfrom";i:10;s:5:"dayto";i:22;}'),
  ('clean_time', '1'),
  ('copyright', 'Powered by JohnCMS'),
  ('email', ''),
  ('flsz', '4000'),
  ('gzip', '1'),
  ('homeurl', ''),
  ('karma', 'a:6:{s:12:"karma_points";i:5;s:10:"karma_time";i:86400;s:5:"forum";i:20;s:4:"time";i:0;s:2:"on";i:1;s:3:"adm";i:0;}'),
  ('lng', 'en'),
  ('mod_reg', '2'),
  ('mod_forum', '2'),
  ('mod_guest', '2'),
  ('mod_lib', '2'),
  ('mod_gal', '2'),
  ('mod_down_comm', '1'),
  ('mod_down', '2'),
  ('mod_lib_comm', '1'),
  ('mod_gal_comm', '1'),
  ('meta_desc', 'Powered by JohnCMS http://johncms.com'),
  ('meta_key', 'johncms'),
  ('news', 'a:8:{s:4:"view";i:1;s:4:"size";i:200;s:8:"quantity";i:5;s:4:"days";i:3;s:6:"breaks";i:1;s:7:"smileys";i:1;s:4:"tags";i:1;s:3:"kom";i:1;}'),
  ('reg_message', ''),
  ('setting_mail', ''),
  ('skindef', 'default'),
  ('them_message', ''),
  ('timeshift', '0'),
  ('site_access', '2');

-- --------------------------------------------------------

--
-- Структура таблицы `cms_users_data`
--

CREATE TABLE IF NOT EXISTS `cms_users_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(30) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `cms_users_iphistory`
--

CREATE TABLE IF NOT EXISTS `cms_users_iphistory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `forum`
--

CREATE TABLE IF NOT EXISTS `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from` varchar(25) NOT NULL DEFAULT '',
  `realid` int(3) NOT NULL DEFAULT '0',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `close` tinyint(1) NOT NULL DEFAULT '0',
  `close_who` varchar(25) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `edit` text NOT NULL,
  `tedit` int(10) unsigned NOT NULL DEFAULT '0',
  `kedit` int(2) unsigned NOT NULL DEFAULT '0',
  `curators` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Дамп данных таблицы `forum`
--

INSERT INTO `forum` (`id`, `refid`, `type`, `time`, `user_id`, `from`, `realid`, `ip`, `ip_via_proxy`, `soft`, `text`, `close`, `close_who`, `vip`, `edit`, `tedit`, `kedit`, `curators`) VALUES
(1, 0, 'f', 0, 0, '', 1, 0, 0, '', 'Muloqot', 0, '', 0, '0', 0, 0, ''),
(2, 0, 'f', 0, 0, '', 2, 0, 0, '', 'Chelsea Fan Club', 0, '', 0, '0', 0, 0, ''),
(3, 0, 'f', 0, 0, '', 3, 0, 0, '', 'Chelsea haqida mulohazalar', 0, '', 0, '0', 0, 0, ''),
(4, 0, 'f', 0, 0, '', 4, 0, 0, '', 'Biz haqimizda', 0, '', 0, '0', 0, 0, ''),
(5, 1, 'r', 0, 0, '', 1, 0, 0, '', 'Erkin mavzular', 0, '', 0, '0', 0, 0, ''),
(6, 1, 'r', 0, 0, '', 2, 0, 0, '', 'Tanishuvlar', 0, '', 0, '0', 0, 0, ''),
(7, 1, 'r', 0, 0, '', 3, 0, 0, '', 'Foydali mavzular', 0, '', 0, '0', 0, 0, ''),
(8, 1, 'r', 0, 0, '', 4, 0, 0, '', 'Kulgu bekati', 0, '', 0, '0', 0, 0, ''),
(9, 1, 'r', 0, 0, '', 5, 0, 0, '', 'Qiziqarli o&#039;yinlar', 0, '', 0, '0', 0, 0, ''),
(10, 2, 'r', 0, 0, '', 1, 0, 0, '', 'Klub futbolchilari', 0, '', 0, '0', 0, 0, ''),
(11, 2, 'r', 0, 0, '', 2, 0, 0, '', 'Sobiq futbolchilar', 0, '', 0, '0', 0, 0, ''),
(12, 2, 'r', 0, 0, '', 3, 0, 0, '', 'Klub afsonalari', 0, '', 0, '0', 0, 0, ''),
(13, 2, 'r', 0, 0, '', 4, 0, 0, '', 'Klub murabbiylari', 0, '', 0, '0', 0, 0, ''),
(14, 2, 'r', 0, 0, '', 5, 0, 0, '', 'Klubimiz haqida', 0, '', 0, '0', 0, 0, ''),
(15, 3, 'r', 0, 0, '', 1, 0, 0, '', 'O&#039;yin oldi fikrlar', 0, '', 0, '0', 0, 0, ''),
(16, 3, 'r', 0, 0, '', 2, 0, 0, '', 'O&#039;yindan keyingi fikrlar', 0, '', 0, '0', 0, 0, ''),
(17, 3, 'r', 0, 0, '', 3, 0, 0, '', 'Transferlar', 0, '', 0, '0', 0, 0, ''),
(18, 3, 'r', 0, 0, '', 4, 0, 0, '', 'Statistikalar', 0, '', 0, '0', 0, 0, ''),
(19, 3, 'r', 0, 0, '', 5, 0, 0, '', 'So&#039;rovnomalar', 0, '', 0, '0', 0, 0, ''),
(20, 4, 'r', 0, 0, '', 1, 0, 0, '', 'Sayt yangiliklari', 0, '', 0, '0', 0, 0, ''),
(21, 4, 'r', 0, 0, '', 2, 0, 0, '', 'Saytimiz haqida', 0, '', 0, '0', 0, 0, ''),
(22, 4, 'r', 0, 0, '', 3, 0, 0, '', 'Bizning loyhalar', 0, '', 0, '0', 0, 0, ''),
(23, 4, 'r', 0, 0, '', 4, 0, 0, '', 'Forum arxivi', 0, '', 0, '0', 0, 0, ''),
(24, 21, 't', 1472647906, 1, 'CHEfan', 0, 0, 0, '', 'Sayt uchun takliflar', 0, '', 0, '', 0, 0, ''),
(25, 24, 'm', 1472647906, 1, 'CHEfan', 0, 2130706433, 0, 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.116 Safari/537.36', 'Sayt uchun qanday takliflaringiz bor? Yoqsa vaqtga qarab albatta bajaramiz.', 0, '', 0, '', 0, 0, '');

-- --------------------------------------------------------

--
-- Структура таблицы `frazy`
--

CREATE TABLE IF NOT EXISTS `frazy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `avtor` varchar(25) NOT NULL,
  `text` text NOT NULL,
  `time` varchar(10) NOT NULL,
  `moder` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Дамп данных таблицы `frazy`
--

INSERT INTO `frazy` (`id`, `avtor`, `text`, `time`, `moder`) VALUES
(1, 'CHEfan', 'Chelsi klubi 1905-yil 10-mart kuni Genri Ogastes Mirs tamonidan yaratilgan.', '1443530611', 1),
(2, 'CHEfan', 'Genri Ogastes Mirs aslida Chelsini yaratish g''oyasi yo''q edi. U sport kompeleksi yaratish niyatida edi.', '1443530750', 1),
(3, 'CHEfan', 'Mirs aslida Chelsini yaratish g''oyasi yo''q edi. U sport kompeleksi yaratish niyatida edi.', '1443530802', 1),
(4, 'CHEfan', 'Chelsi futbol tarixida rasmiy uchrashuv o''tkazmasdan yuqori chempionatga qo''shilgan jamoadir.', '1443530948', 1),
(5, 'CHEfan', 'Klubimiz xo''jayini Roman Abramovich 1966-yil 24-oktyabr kuni Saratov shahrida tug''ilgan.', '1443531047', 1),
(6, 'CHEfan', 'Abramovich 6 oyligida onasi, 4 yoshida otasi vafot etgan.', '1443531178', 1),
(7, 'CHEfan', 'Abramovich 2002-yil iyul oyida Chelsining aksiya patentlarini sotib olgan.', '1443531556', 1),
(8, 'CHEfan', 'Stamford Brij 1905-yil endi yaratilgan Chelsi klubiga topshirilgan.', '1443531687', 1),
(9, 'CHEfan', 'Stamford BriJning arxitektori va asoschisi Archibald Leytchem hisoblanadi.', '1443531742', 1),
(10, 'CHEfan', 'Hozirgi vaqtda Stamford Brij sig''imi 41841 kishini tashkil etadi.', '1443531859', 1),
(11, 'CHEfan', 'Blue it the Colour - Chelsi klubining rasmiy qo''shig''i va gimini hisoblanadi.', '1443531943', 1);

-- --------------------------------------------------------

--
-- Структура таблицы `games`
--

CREATE TABLE IF NOT EXISTS `games` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `team1` varchar(50) NOT NULL,
  `logo1` varchar(20) NOT NULL,
  `score1` tinyint(3) NOT NULL DEFAULT '0',
  `team2` varchar(50) NOT NULL,
  `logo2` varchar(20) NOT NULL,
  `score2` tinyint(3) NOT NULL DEFAULT '0',
  `when` int(12) NOT NULL,
  `championat` varchar(99) NOT NULL,
  `stadium` varchar(50) NOT NULL,
  `referee` varchar(50) NOT NULL,
  `referee1` varchar(50) NOT NULL,
  `referee2` varchar(50) NOT NULL,
  `referee3` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `games_game`
--

CREATE TABLE IF NOT EXISTS `games_game` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) NOT NULL,
  `who1` varchar(50) NOT NULL,
  `what1` varchar(10) NOT NULL,
  `when` int(12) NOT NULL,
  `what2` varchar(20) NOT NULL,
  `who2` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `games_info`
--

CREATE TABLE IF NOT EXISTS `games_info` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `ref` int(3) unsigned NOT NULL,
  `pl1_1` varchar(50) NOT NULL,
  `pl2_1` varchar(50) NOT NULL,
  `pl3_1` varchar(50) NOT NULL,
  `pl4_1` varchar(50) NOT NULL,
  `pl5_1` varchar(50) NOT NULL,
  `pl6_1` varchar(50) NOT NULL,
  `pl7_1` varchar(50) NOT NULL,
  `pl8_1` varchar(50) NOT NULL,
  `pl9_1` varchar(50) NOT NULL,
  `pl10_1` varchar(50) NOT NULL,
  `pl11_1` varchar(50) NOT NULL,
  `pz1_1` varchar(50) NOT NULL,
  `pz2_1` varchar(50) NOT NULL,
  `pz3_1` varchar(50) NOT NULL,
  `pz4_1` varchar(50) NOT NULL,
  `pz5_1` varchar(50) NOT NULL,
  `pz6_1` varchar(50) NOT NULL,
  `pz7_1` varchar(50) NOT NULL,
  `pl1_2` varchar(50) NOT NULL,
  `pl2_2` varchar(50) NOT NULL,
  `pl3_2` varchar(50) NOT NULL,
  `pl4_2` varchar(50) NOT NULL,
  `pl5_2` varchar(50) NOT NULL,
  `pl6_2` varchar(50) NOT NULL,
  `pl7_2` varchar(50) NOT NULL,
  `pl8_2` varchar(50) NOT NULL,
  `pl9_2` varchar(50) NOT NULL,
  `pl10_2` varchar(50) NOT NULL,
  `pl11_2` varchar(50) NOT NULL,
  `pz1_2` varchar(50) NOT NULL,
  `pz2_2` varchar(50) NOT NULL,
  `pz3_2` varchar(50) NOT NULL,
  `pz4_2` varchar(50) NOT NULL,
  `pz5_2` varchar(50) NOT NULL,
  `pz6_2` varchar(50) NOT NULL,
  `pz7_2` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `karma_users`
--

CREATE TABLE IF NOT EXISTS `karma_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `karma_user` int(10) unsigned NOT NULL DEFAULT '0',
  `points` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `news_cats`
--

CREATE TABLE IF NOT EXISTS `news_cats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `pos` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Дамп данных таблицы `news_cats`
--

INSERT INTO `news_cats` (`id`, `name`, `pos`) VALUES
(1, 'Chelsi yangiliklari', 1),
(2, 'Transferlar', 2),
(3, 'Intervyular', 3),
(4, 'Prewyular', 4),
(5, 'Natijalar', 5),
(6, 'Jarohatlar', 6),
(7, 'Chempionlar Ligasi', 7),
(8, 'Premier Liga', 8),
(9, 'Angilya Kuboki', 9),
(10, 'Terma jamoalar', 10),
(11, 'Ijaradagilar', 11),
(12, 'Statistikalar', 12),
(13, 'Foto lavhalar', 13),
(14, 'Boshqa yangiliklar', 14),
(15, 'Sayt yangiliklari', 15),
(16, 'Bizning loyihalar', 16);

-- --------------------------------------------------------

--
-- Структура таблицы `news_texts`
--

CREATE TABLE IF NOT EXISTS `news_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `uploader` varchar(100) NOT NULL DEFAULT '',
  `uploader_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count_views` int(10) unsigned NOT NULL DEFAULT '0',
  `premod` tinyint(1) NOT NULL DEFAULT '0',
  `count_comments` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `players`
--

CREATE TABLE IF NOT EXISTS `players` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `imname` varchar(150) NOT NULL DEFAULT '',
  `dayb` varchar(2) NOT NULL DEFAULT '',
  `monthb` varchar(2) NOT NULL DEFAULT '',
  `yearb` varchar(4) NOT NULL DEFAULT '',
  `countryb` varchar(50) NOT NULL DEFAULT '',
  `cityb` varchar(50) NOT NULL DEFAULT '',
  `nationality` varchar(50) NOT NULL DEFAULT '',
  `position` varchar(20) NOT NULL DEFAULT '',
  `foot` varchar(25) NOT NULL DEFAULT '',
  `number` varchar(2) NOT NULL DEFAULT '',
  `height` varchar(3) NOT NULL DEFAULT '',
  `weight` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Дамп данных таблицы `players`
--

INSERT INTO `players` (`id`, `name`, `imname`, `dayb`, `monthb`, `yearb`, `countryb`, `cityb`, `nationality`, `position`, `foot`, `number`, `height`, `weight`) VALUES
(1, 'Thibaut Courtois', 'Thibaut Courtois', '11', '05', '1992', 'Belgiya', 'Bree', 'Belgiya', 'Darvozabon', 'Chap oyoqda', '13', '199', '91'),
(2, 'Asmir Begovic', 'Asmir Begovic', '20', '06', '1987', 'Bosniya va Gersagavina', 'Trebinje', 'Bosniya va Gersagavina', 'Darvozabon', 'O''ng oyoqda', '1', '198', '83'),
(3, 'Eduardo', 'Eduardo dos Reis Carvalho', '19', '09', '1982', 'Portugalya', 'Mirandela', 'Portugalya', 'Darvozabon', 'O''ng oyoqda', '37', '187', '89'),
(4, 'Cesar Azpilicueta', 'Cesar Azpilicueta Tanco', '28', '08', '1989', 'Ispanya', 'Pamploma', 'Ispanya', 'Himoyachi', 'O''ng oyoqda', '28', '178', '75'),
(5, 'Gary Cahill', 'Gary Cahill', '19', '12', '1985', 'Angilya', 'Dronfield', 'Angilya', 'Himoyachi', 'O''ng oyoqda', '24', '193', '86'),
(6, 'Marcos Alonso', 'Marcos Alonso Mendoza', '28', '12', '1990', 'Ispanya', 'Madrid', 'Ispanya', 'Himoyachi', 'Chap oyoqda', '3', '188', '81'),
(7, 'Branislav Ivanovic', 'Branislav Ivanovic', '22', '02', '1984', 'Serbiya', 'Sremska Mitrovica', 'Serbiya', 'Himoyachi', 'O''ng oyoqda', '2', '185', '91'),
(8, 'David Luiz', 'David Luiz Moreira Marinho', '22', '04', '1987', 'Brazilya', 'Diadema', 'Brazilya', 'Himoyachi', 'O''ng oyoqda', '30', '189', '84'),
(9, 'Ola Aina', 'Temitayo Olufisayo Olaoluwa Aina', '08', '10', '1996', 'Angilya', 'London', 'Angilya', 'Himoyachi', 'O''ng oyoqda', '34', '175', '65'),
(10, 'John Terry', 'John Terry', '07', '12', '1980', 'Angilya', 'London', 'Angilya', 'Himoyachi', 'O''ng oyoqda', '26', '187', '90'),
(11, 'Kurt Zouma', 'Kurt Zouma', '27', '10', '1994', 'Fransiya', 'Lyon', 'Fransiya', 'Himoyachi', 'O''ng oyoqda', '5', '190', '92'),
(12, 'Nathaniel Chalobah', 'Nathaniel Chalobah', '12', '12', '1994', 'Sierra Leone', 'Freetown', 'Angilya', 'Yarim himoyachi', 'O''ng oyoqda', '29', '185', ''),
(13, 'Willian', 'Willian Borges Da Silva', '09', '08', '1988', 'Brazilya', 'Riberiao', 'Brazilya', 'Yarim himoyachi', 'Ikkala oyoqda', '22', '175', '75'),
(14, 'Oscar', 'Oscar dos Santos Emboaba Junior', '09', '09', '1991', 'Brazilya', 'Americana', 'Brazilya', 'Yarim himoyachi', 'O''ng oyoqda', '8', '179', '67'),
(15, 'Cesc Fabregas', 'Francesc Fabregas i Soler', '04', '05', '1987', 'Ispanya', 'Velassar de Mar', 'Ispanya', 'Yarim himoyachi', 'O''ng oyoqda', '4', '175', '74'),
(16, 'Eden Hazard', 'Eden Hazard', '07', '01', '1991', 'Belgiya', 'La Louriere', 'Belgiya', 'Yarim himoyachi', 'Ikkala oyoqda', '10', '173', '74'),
(17, 'N''Golo Kante', 'N''Golo Kante', '29', '03', '1991', 'Fransiya', 'Paris', 'Fransiya', 'Yarim himoyachi', 'O''ng oyoqda', '7', '169', '68'),
(18, 'Ruben Loftus-Cheek', 'Ruben Loftus-Cheek', '23', '01', '1996', 'Angilya', 'London', 'Angilya', 'Yarim himoyachi', 'O''ng oyoqda', '14', '191', '83'),
(19, 'Nemanja Matic', 'Nemanja Matic', '01', '08', '1988', 'Serbiya', 'Sabac', 'Serbiya', 'Yarim himoyachi', 'Chap oyoqda', '21', '194', '84'),
(20, 'Victor Moses', 'Victor Moses', '12', '12', '1990', 'Nigerya', 'Kaduna', 'Nigerya', 'Yarim himoyachi', 'Ikkala oyoqda', '15', '177', '76'),
(21, 'John Obi Mikel', 'John Michael Nchekwube Obinna', '22', '04', '1987', 'Nigerya', 'Jos', 'Nigerya', 'Yarim himoyachi', 'Ikkala oyoqda', '12', '188', '83'),
(22, 'Pedro', 'Pedro Eliezer Rodriguez Ledesma', '28', '07', '1987', 'Ispanya', 'Santa Cruz de Tenerife', 'Ispanya', 'Yarim himoyachi', 'Ikkala oyoqda', '11', '167', '62'),
(23, 'Michy Batshuayi', 'Michy Batshuayi Tunga', '02', '10', '1993', 'Belgiya', 'Brussels', 'Belgiya', 'Hujumchi', 'Ikkala oyoqda', '23', '182', '78'),
(24, 'Diego Costa', 'Diego Da Silva Costa', '07', '10', '1988', 'Brazilya', 'Lagarto', 'Ispanya', 'Hujumchi', 'O''ng oyoqda', '19', '188', '85'),
(25, 'Antonio Conte', 'Antonio Conte', '31', '07', '1969', 'Italiya', 'Lecce', 'Italiya', 'Bosh murabbiy', '', '', '178', '73');

-- --------------------------------------------------------

--
-- Структура таблицы `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `name_lat` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `rights` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `failed_login` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `imname` varchar(50) NOT NULL DEFAULT '',
  `sex` varchar(2) NOT NULL DEFAULT '',
  `komm` int(10) unsigned NOT NULL DEFAULT '0',
  `postforum` int(10) unsigned NOT NULL DEFAULT '0',
  `postguest` int(10) unsigned NOT NULL DEFAULT '0',
  `postchat` int(11) NOT NULL,
  `yearofbirth` int(4) NOT NULL DEFAULT '0',
  `datereg` int(10) unsigned NOT NULL DEFAULT '0',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `mail` varchar(50) NOT NULL DEFAULT '',
  `live` varchar(100) NOT NULL DEFAULT '',
  `mibile` varchar(50) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` text NOT NULL,
  `preg` tinyint(1) NOT NULL DEFAULT '0',
  `regadm` varchar(25) NOT NULL DEFAULT '',
  `mailvis` tinyint(1) NOT NULL DEFAULT '0',
  `dayb` int(2) NOT NULL DEFAULT '0',
  `monthb` int(2) NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `total_on_site` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `rest_code` varchar(32) NOT NULL DEFAULT '',
  `rest_time` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` int(10) unsigned NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL DEFAULT '',
  `set_user` text NOT NULL,
  `set_forum` text NOT NULL,
  `set_mail` text NOT NULL,
  `karma_plus` int(11) NOT NULL DEFAULT '0',
  `karma_minus` int(11) NOT NULL DEFAULT '0',
  `karma_time` int(10) unsigned NOT NULL DEFAULT '0',
  `karma_off` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comm_old` int(10) unsigned NOT NULL DEFAULT '0',
  `smileys` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;