<?php

define('_IN_JOHNCMS', 1);
require('incfiles/core.php');
$textl = $lng['registration'];
$headmod = 'registration';
require('incfiles/head.php');
$lng_reg = core::load_lng('registration');

// Если регистрация закрыта, выводим предупреждение
if (core::$deny_registration || !$set['mod_reg'] || core::$user_id) {
    echo '<p>' . $lng_reg['registration_closed'] . '</p>';
    require('incfiles/end.php');
    exit;
}

$reg_nick = isset($_POST['nick']) ? trim($_POST['nick']) : '';
$lat_nick = functions::rus_lat(mb_strtolower($reg_nick));
$reg_pass = isset($_POST['password']) ? trim($_POST['password']) : '';
$reg_name = isset($_POST['imname']) ? trim($_POST['imname']) : '';
$reg_mail = isset($_POST['mail']) ? trim($_POST['mail']) : '';
$reg_dayb = isset($_POST['dayb']) ? trim($_POST['dayb']) : '';
$reg_monthb = isset($_POST['monthb']) ? trim($_POST['monthb']) : '';
$reg_yearofbirth = isset($_POST['yearofbirth']) ? trim($_POST['yearofbirth']) : '';
$reg_live = isset($_POST['live']) ? trim($_POST['live']) : '';
$reg_mibile = isset($_POST['mibile']) ? trim($_POST['mibile']) : '';
$reg_sex = isset($_POST['sex']) ? functions::check(mb_substr(trim($_POST['sex']), 0, 2)) : '';

echo '<div class="phdr"><b>' . $lng['registration'] . '</b></div>';
if (isset($_POST['submit'])) {
    // Принимаем переменные
    $error = array();

    // Проверка Логина
    if (empty($reg_nick)) {
        $error['login'][] = $lng_reg['error_nick_empty'];
    } elseif (mb_strlen($reg_nick) < 2 || mb_strlen($reg_nick) > 15) {
        $error['login'][] = $lng_reg['error_nick_lenght'];
    }
    if (preg_match('/[^\d0-9a-z\-\_]+/', $reg_nick)) {
        $error['login'][] = $lng['error_wrong_symbols'];
    }
    if (preg_match('/[^\d0-9a-z\-\_]+/', $lat_nick)) {
        $error['login'][] = $lng['error_wrong_symbols'];
    }

    // Проверка пароля
    if (empty($reg_pass)) {
        $error['password'][] = $lng['error_empty_password'];
    } elseif (mb_strlen($reg_pass) < 3 || mb_strlen($reg_pass) > 10) {
        $error['password'][] = $lng['error_password_lenght'];
    }
    if (preg_match('/[^\dA-Za-z]+/', $reg_pass)) {
        $error['password'][] = $lng['error_wrong_symbols'];
    }
	
	// Проверка имени
    if (empty($reg_name))
        $error['imname'][] = $lng_reg['error_name_empty'];
    elseif (mb_strlen($reg_name) < 2 || mb_strlen($reg_name) > 30)
        $error['imname'][] = $lng_reg['error_name_lenght'];
    if (preg_match('/[^\d0-9A-Za-z]+/', $reg_name)) {
        $error['imname'][] = $lng['error_wrong_symbols'];
    }

    // Проверка пола
    if ($reg_sex != 'm' && $reg_sex != 'zh') {
        $error['sex'] = $lng_reg['error_sex'];
    }
	
	// Проверка почты
    if (empty($reg_mail))
        $error['mail'][] = $lng_reg['error_mail_empty'];
    elseif (mb_strlen($reg_mail) < 6 || mb_strlen($reg_mail) > 40)
        $error['mail'][] = $lng_reg['error_wrong_lenght'];
	
	// Проверка даты рождения
    if (empty($reg_dayb))
        $error['dayb'][] = $lng_reg['dayb'];
	if (empty($reg_monthb))
        $error['monthb'][] = $lng_reg['monthb'];
	if (empty($reg_yearofbirth))
        $error['yearofbirth'][] = $lng_reg['yearofbirth'];
	
	// Проверка города
    if (empty($reg_live))
        $error['live'][] = $lng_reg['error_live_empty'];
    elseif (mb_strlen($reg_live) < 2 || mb_strlen($reg_live) > 100)
        $error['live'][] = $lng_reg['error_live_lenght'];

    // Проверка переменных
    if (empty($error)) {
        $pass = md5(md5($reg_pass));
        $reg_name = functions::check(mb_substr($reg_name, 0, 20));
        // Проверка, занят ли ник
        $req = mysql_query("SELECT * FROM `users` WHERE `name_lat`='" . mysql_real_escape_string($lat_nick) . "'");
        if (mysql_num_rows($req) != 0) {
            $error['login'][] = $lng_reg['error_nick_occupied'];
        }
		// Проверка, занят ли email
        $ren = mysql_query("SELECT * FROM `users` WHERE `mail`='" . mysql_real_escape_string($reg_mail) . "'");
        if (mysql_num_rows($ren) != 0) {
            $error['mail'][] = $lng_reg['error_mail_occupied'];
        }
    }
    if (empty($error)) {
        $preg = $set['mod_reg'] > 1 ? 1 : 0;
        mysql_query("INSERT INTO `users` SET
            `name` = '" . mysql_real_escape_string($reg_nick) . "',
            `name_lat` = '" . mysql_real_escape_string($lat_nick) . "',
            `password` = '" . mysql_real_escape_string($pass) . "',
            `imname` = '$reg_name',
            `sex` = '$reg_sex',
			`dayb` = '$reg_dayb',
			`monthb` = '$reg_monthb',
			`yearofbirth` = '$reg_yearofbirth',
			`live` = '$reg_live',
			`mail` = '$reg_mail',
			`mibile` = '$reg_mibile',
            `rights` = '0',
            `ip` = '" . core::$ip . "',
            `ip_via_proxy` = '" . core::$ip_via_proxy . "',
            `browser` = '" . mysql_real_escape_string($agn) . "',
            `datereg` = '" . time() . "',
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `preg` = '$preg',
            `set_user` = '',
            `set_forum` = '',
            `set_mail` = ''
        ") or exit(__LINE__ . ': ' . mysql_error());
        $usid = mysql_insert_id();

        // Отправка системного сообщения
        $set_mail = unserialize($set['setting_mail']);

        if (!isset($set_mail['message_include'])) {
            $set_mail['message_include'] = 0;
        }

        if ($set_mail['message_include']) {
            $array = array('{LOGIN}', '{TIME}');
            $array_replace = array($reg_nick, '{TIME=' . time() . '}');

            if (empty($set['them_message'])) {
                $set['them_message'] = $lng_mail['them_message'];
            }

            if (empty($set['reg_message'])) {
                $set['reg_message'] = $lng['hi'] . ", {LOGIN}\r\n" . $lng_mail['pleased_see_you'] . "\r\n" . $lng_mail['come_my_site'] . "\r\n" . $lng_mail['respectfully_yours'];
            }

            $theme = str_replace($array, $array_replace, $set['them_message']);
            $system = str_replace($array, $array_replace, $set['reg_message']);
            mysql_query("INSERT INTO `cms_mail` SET
			    `user_id` = '0',
			    `from_id` = '" . $usid . "',
			    `text` = '" . mysql_real_escape_string($system) . "',
			    `time` = '" . time() . "',
			    `sys` = '1',
			    `them` = '" . mysql_real_escape_string($theme) . "'
			");
        }

        echo '<div class="menu"><p><h3>' . $lng_reg['you_registered'] . '</h3>' . $lng_reg['your_id'] . ': <b>' . $usid . '</b><br/>' . $lng_reg['your_login'] . ': <b>' . $reg_nick . '</b><br/>' . $lng_reg['your_password'] . ': <b>' . $reg_pass . '</b></p>';

        if ($set['mod_reg'] == 1) {
            echo '<p><span class="red"><b>' . $lng_reg['moderation_note'] . '</b></span></p>';
        } else {
            $_SESSION['uid'] = $usid;
            $_SESSION['ups'] = md5(md5($reg_pass));
            echo '<p><a href="' . $home . '">' . $lng_reg['enter'] . '</a></p>';
        }

        echo '</div>';
        require('incfiles/end.php');
        exit;
    }
}

/*
-----------------------------------------------------------------
Форма регистрации
-----------------------------------------------------------------
*/
if ($set['mod_reg'] == 1) echo '<div class="rmenu"><p>' . $lng_reg['moderation_warning'] . '</p></div>';
echo '<form action="registration.php" method="post"><div class="menu">' .
    '<p><h3>' . $lng_reg['login'] . ': <span class="red">*</span></h3>' .
    (isset($error['login']) ? '<span class="red"><small>' . implode('<br />', $error['login']) . '</small></span><br />' : '') .
    '<input type="text" name="nick" maxlength="15" value="' . htmlspecialchars($reg_nick) . '"' . (isset($error['login']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<small>' . $lng_reg['login_help'] . '</small></p>' .
	
    '<p><h3>' . $lng_reg['password'] . ': <span class="red">*</span></h3>' .
    (isset($error['password']) ? '<span class="red"><small>' . implode('<br />', $error['password']) . '</small></span><br />' : '') .
    '<input type="text" name="password" maxlength="20" value="' . htmlspecialchars($reg_pass) . '"' . (isset($error['password']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '<small>' . $lng_reg['password_help'] . '</small></p>' .
	
	'<p><h3>' . $lng_reg['name'] . ': <span class="red">*</span></h3>' .
	(isset($error['imname']) ? '<span class="red"><small>' . implode('<br />', $error['imname']) . '</small></span><br />' : '') .
    '<input type="text" name="imname" maxlength="30" value="' . htmlspecialchars($reg_name) . '"' . (isset($error['imname']) ? ' style="background-color: #FFCCCC"' : '') . ' /><br />' .
    '<small>' . $lng_reg['name_help'] . '</small></p>' .
	
    '<p><h3>' . $lng_reg['birth_date'] . ': <span class="red">*</span></h3>' .
	(isset($error['dayb']) ? '<span class="red"><small>' . implode('<br />', $error['dayb']) . '</small></span><br />' : '') .
	(isset($error['monthb']) ? '<span class="red"><small>' . implode('<br />', $error['monthb']) . '</small></span><br />' : '') .
	(isset($error['yearofbirth']) ? '<span class="red"><small>' . implode('<br />', $error['yearofbirth']) . '</small></span><br />' : '') .
	'<select name="dayb"' . (isset($error['dayb']) ? ' style="background-color: #FFCCCC"' : '') . '>';
        for ($i = 1; $i < 32; $i++) {
            echo '<option name="dayb" value="'.$i.'" ' . ($reg_dayb == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
        }
	echo '</select>';
    echo '<select name="monthb"' . (isset($error['monthb']) ? ' style="background-color: #FFCCCC"' : '') . '>
            <option name="monthb" value="1" ' . ($reg_monthb == '1' ? ' selected="selected"' : '') . '>Yanvar</option>
            <option name="monthb" value="2" ' . ($reg_monthb == '2' ? ' selected="selected"' : '') . '>Fevral</option>
            <option name="monthb" value="3" ' . ($reg_monthb == '3' ? ' selected="selected"' : '') . '>Mart</option>
            <option name="monthb" value="4" ' . ($reg_monthb == '4' ? ' selected="selected"' : '') . '>Aprel</option>
            <option name="monthb" value="5" ' . ($reg_monthb == '5' ? ' selected="selected"' : '') . '>May</option>
            <option name="monthb" value="6" ' . ($reg_monthb == '6' ? ' selected="selected"' : '') . '>Iyun</option>
            <option name="monthb" value="7" ' . ($reg_monthb == '7' ? ' selected="selected"' : '') . '>Iyul</option>
            <option name="monthb" value="8" ' . ($reg_monthb == '8' ? ' selected="selected"' : '') . '>Avgust</option>
            <option name="monthb" value="9" ' . ($reg_monthb == '9' ? ' selected="selected"' : '') . '>Sentyabr</option>
            <option name="monthb" value="10" ' . ($reg_monthb == '10' ? ' selected="selected"' : '') . '>Oktyabr</option>
            <option name="monthb" value="11" ' . ($reg_monthb == '11' ? ' selected="selected"' : '') . '>Noyabr</option>
            <option name="monthb" value="12" ' . ($reg_monthb == '12' ? ' selected="selected"' : '') . '>Dekabr</option>
        </select>';
	echo '<select name="yearofbirth"' . (isset($error['yearofbirh']) ? ' style="background-color: #FFCCCC"' : '') . '>';
            for ($i = 1950; $i < 2014; $i++) {
                echo '<option name="yearofbirth" value="'.$i.'" ' . ($reg_yearofbirth == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
            }
	echo '</select></p>' .
    '<p><h3>' . $lng_reg['live'] . ': <span class="red">*</span></h3>' .
    (isset($error['live']) ? '<span class="red"><small>' . implode('<br />', $error['live']) . '</small></span><br />' : '') .
       '<select name="live"' . (isset($error['live']) ? ' style="background-color: #FFCCCC"' : '') . ' value="' . $reg_live . '">
	        <option value="">Viloyatingizni tanlang</option>
            <option ' . ($reg_live == 'Andijon viloyati' ? ' selected="selected"' : '') . '>Andijon viloyati</option>
            <option ' . ($reg_live == 'Buxoro viloyati' ? ' selected="selected"' : '') . '>Buxoro viloyati</option>
            <option ' . ($reg_live == 'Farg‘ona viloyati' ? ' selected="selected"' : '') . '>Farg‘ona viloyati</option>
            <option ' . ($reg_live == 'Jizzax viloyati' ? ' selected="selected"' : '') . '>Jizzax viloyati</option>
<option ' . ($reg_live == 'Namangan viloyati' ? ' selected="selected"' : '') . '>Namangan viloyati</option>
            <option ' . ($reg_live == 'Navoiy viloyati' ? ' selected="selected"' : '') . '>Navoiy viloyati</option>
            <option ' . ($reg_live == 'Qashqadaryo viloyati' ? ' selected="selected"' : '') . '>Qashqadaryo viloyati</option>
<option ' . ($reg_live == 'Qoraqalpog‘iston' ? ' selected="selected"' : '') . '>Qoraqalpog‘iston</option>
<option ' . ($reg_live == 'Samarqand viloyati' ? ' selected="selected"' : '') . '>Samarqand viloyati</option>
            <option ' . ($reg_live == 'Sirdaryo viloyati' ? ' selected="selected"' : '') . '>Sirdaryo viloyati</option>
<option ' . ($reg_live == 'Surxondaryo viloyati' ? ' selected="selected"' : '') . '>Surxondaryo viloyati</option>
            <option ' . ($reg_live == 'Xorazm viloyati' ? ' selected="selected"' : '') . '>Xorazm viloyati</option>
            <option ' . ($reg_live == 'Toshkent viloyati' ? ' selected="selected"' : '') . '>Toshkent viloyati</option>
            <option ' . ($reg_live == 'Toshkent shahri' ? ' selected="selected"' : '') . '>Toshkent shahri</option>
        </select></p>' .
	
    '<p><h3>' . $lng_reg['sex'] . ': <span class="red">*</span></h3>' .
    (isset($error['sex']) ? '<span class="red"><small>' . $error['sex'] . '</small></span><br />' : '') .
    '<select name="sex"' . (isset($error['sex']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
    '<option value="?">-?-</option>' .
    '<option value="m"' . ($reg_sex == 'm' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_m'] . '</option>' .
    '<option value="zh"' . ($reg_sex == 'zh' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_w'] . '</option>' .
    '</select></p>' .
	
	'<p><h3>' . $lng_reg['email'] . ': <span class="red">*</span></h3>' .
    (isset($error['mail']) ? '<span class="red"><small>' . implode('<br />', $error['mail']) . '</small></span><br />' : '') .
    '<input type="text" name="mail" maxlength="20" value="' . htmlspecialchars($reg_mail) . '"' . (isset($error['mail']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '<small>' . $lng_reg['email_help'] . '</small></p>' .
	
	'<p><h3>' . $lng_reg['mibile'] . ':</h3><input type="text" name="mibile" maxlength="30" value="' . htmlspecialchars($reg_mibile) . '"/><br /></p>' .
	'<input type="submit" name="submit" value="' . $lng_reg['registration'] . '"/></p></div></form>' .
    '<div class="phdr"><small>' . $lng_reg['registration_terms'] . '</small></div>';

require('incfiles/end.php');