<?php
defined('CleverSOFT') or die('Foydalanish cheklangan');

# sessiya nomi
session_name('ses');
# sessiya boshlanishi
session_start();

ob_start ();

# Xatoliklarni yashirish
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', true);
ini_set('html_errors', true);
ini_set('error_reporting', E_ALL ^ E_NOTICE);

ini_set('session.cookie_lifetim', '0');
ini_set('zlib.output_compression', '1');
ini_set('arg_separator.output', '&amp;');
ini_set('register_globals', '0');
ini_set('magic_quotes_gpc', '0');
mb_internal_encoding('UTF-8');

# soat mintaqasi
date_default_timezone_set('Asia/Tashkent');

# ildiz
define('root', dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR);
# asosiy bo'lim
define ('core', root.'/core/');
# ba'za ma'lumotlari bo'limi
define ('config', core.'config/');
# funktsiyalar bo'limi
define ('fnc', core.'functions/');
# classlar bo'limi
define ('classes', core.'classes/');

# Ma'lumotlar bazasi
require (config.'config.php');

# Avtomatik funktsiyalarni yuklash
$opdirbase = opendir(fnc);
while ($filebase = readdir($opdirbase)) 
{
	if (preg_match('#\.php$#i',$filebase)) 
	{
		include_once(fnc.''.$filebase);
	}
}

# Avtomatik classlarni yuklash
$opdirbase = opendir(classes);
while ($filebase = readdir($opdirbase)) 
{
	if (preg_match('#\.php$#i',$filebase)) 
	{
		include_once(classes.''.$filebase);
	}
}

# Asosiy tizm ma'lumotlari
require (config.'core.php');
# Foydalanuvchilar uchun
require (config.'user.php');
# Tepa qism
define ('head', config.'head.php');
# Pastki qism
define ('foot', config.'foot.php');

?>