<?php
class Navigator {
    /**
     * конструктор
     *
     */
    function __construct($script,$pnumber,$query='') {
        $this->script=$script;
 
        //если не задано имя скрипта, то используем текущее
        if (empty($script)) {
            $this->script=$_SERVER['SCRIPT_NAME'];
        }
 
        //элементов на страницу
        $this->pnumber=$pnumber;
 
        $this->query='';
        $this->or_query=$query;
 
        //если задана строка параметров
        if (is_array($query)) {
            foreach ($query as $k=>$v) {
                $this->query.='&amp;'.$k.'='.urlencode($v);
            }
        }
 
        //обработка текущего номера страницы
        $this->page=isset($_GET['page']) ? (int)$_GET['page'] : 1;
    }
 
    /**
     * Инициализация навигатора, вычесление стартовой позиции
     */
    function start() {
 
        //вычисление стартовой позиции
        $this->start = $this->page * $this->pnumber - $this->pnumber;
 
        //обработка левых номеров
        if ($this->page < 1) {
            $this->page=1;
            $this->start=0;
        }
 
        return $this->start;
    }
 
    /**
     * Печать навигатора
     */
    function navi($all,$input=0) {
 
        //всего элементов
        $this->all=$all;
 
        //число страниц
        $this->num_pages=ceil($this->all/$this->pnumber);
 
        //если страниц более 5, то выводим форму
        if ($this->num_pages > 5) $input=1;
 
        //проверка корректности
        if ($this->page > $this->num_pages || $this->page < 1) {
            $this->page=1;
            $this->start=0;
        }
 
        //не печатаем навигатор, если всего одна страница
        if ($this->num_pages<2)
        return '';
 
        $buff='<div class="hay">';
 
        //блок вперед
        if ($this->page>1)
        $buff.='<a href="'.$this->script.'page='.($this->page-1).$this->query.'"> <span class="on">&lt;</span></a>';
        else
        $buff.='';
 
        //блок ссылок
        for($pr = '', $i =1; $i <= $this->num_pages; $i++) {
            $buff.=
            $pr=(($i == 1 || $i == $this->num_pages || abs($i-$this->page) < 2) ? ($i == $this->page ? " <span class='on'>$i</span> " : ' <a href="'.$this->script.'page='.$i.$this->query.'"><span class="on">'.$i.'</span></a> ') : (($pr == ' ... ' || $pr == '')? '' : ' ... '));
        }
 
        //блок назад
        if ($this->page<$this->num_pages)
        $buff.='<a href="'.$this->script.'page='.($this->page+1).$this->query.'"><span class="on">&gt;</span></a>';
        else
        $buff.='';
 
        //печатаем форму с полем ввода (можно это убрать отсюда если не требуется)
        if ($input) {
            $buff.='<form style="margin:0" action="'.$this->script.'" method="get"><p style="margin:0">';
 
            $buff.='<input size="2" name="page" value="'.$this->page.'"/>';
 
            if (!empty($this->query)) {
                foreach ($this->or_query as $name=>$value) {
                    $buff.='<input type="hidden" name="'.$name.'" value="'.htmlspecialchars($value).'" />';
                }
            }
 
            $buff.='<input type="submit" value="&gt;&gt;"/></p></form>';
        }
 
        $buff.='</div>
		<div class="clear"></div>
		';
 
        return $buff;
    }
}