<?php
// Функция отфильтровки чисел
function intv($int)
{
	return abs((int)$int);
}

// Функция защиты от нежелательных действий
function protect($string)
{
	return trim(htmlspecialchars($string, ENT_QUOTES, 'utf-8'));
}

// откуда сидит пользователь
function check_smartphone() {
 
    $phone_array = array('iphone', 'android', 'pocket', 'palm', 'windows ce', 'windowsce', 'cellphone', 'opera mobi', 'ipod', 'small', 'sharp', 'sonyericsson', 'symbian', 'opera mini', 'nokia', 'htc_', 'samsung', 'motorola', 'smartphone', 'blackberry', 'playstation portable', 'tablet browser');
    $agent = strtolower( $_SERVER['HTTP_USER_AGENT'] );
 
    foreach ($phone_array as $value) {
 
        if ( strpos($agent, $value) !== false ) return true;
 
    }
 
    return false;
 
}
// размер файла
function size_data($filesize = 0) {
        $filesize_ed = 'байт';
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Кб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Мб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Гб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Тб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Пб';
        }

        return $filesize . ' ' . $filesize_ed;
    }
function url_replace($m) {
  if (!isset($m[3])) {
    return '<a href="' . $m[1] . '">' . $m[2] . '</a>';
  } else {
    return '<a href="' . $m[3] . '">' . $m[3] . '</a>';
  }
} 

// Функции BB кодов
function bbcode($text)
{
	$bbcode = array(
		'/\[i\](.+)\[\/i\]/isU'                                           =>'<i>$1</i>',
		'/\[quote\](.+)\[\/quote\]/isU'                                   =>'<div class="q">$1</div>',
 		'/\[b\](.+)\[\/b\]/isU'                                           =>'<b>$1</b>',
		'/\[del\](.+)\[\/del\]/isU'                                       =>'<span style="text-decoration: line-through">$1</span>',
		'/\[u\](.+)\[\/u\]/isU'                                           =>'<span style="text-decoration:underline">$1</span>',
		'/\[big\](.+)\[\/big\]/isU'                                       =>'<big>$1</big>',
		'/\[small\](.+)\[\/small\]/isU'                                   =>'<small>$1</small>',
		'/\[color=(.+)\](.+)\[\/color\]/isU'                              =>'<span style="color:#$1">$2</span>',
		);
 	return preg_replace(array_keys($bbcode),array_values($bbcode),$text);
}
function bblinks($link)
{
    $link = preg_replace_callback('~\\[url=(http://.+?)\\](.+?)\\[/url\\]|(http://(www.)?[0-9a-z\.\-]+\.[0-9a-z]{2,6}[0-9a-zA-Z/\?\.\-\~&;_=%:#\+]*)~', 'url_replace', $link);
 	return $link;
}

function bbcodereturn($text)
{
   	$bbcode = array(
      	'/<a href="(.+)">(.+)<\/a>/isU'                                   => '[url]$1[/url]',
      	'/<a href="(.+)">(.+)<\/a>/isU'                                   => '[url=$1]$2[/url]',
      	'/<br \/>/isU'                                                    => '[br]',
      	'/<i>(.+)<\/i>/isU'                                               => '[i]$1[/i]',
      	'/<strong\>(.+)<\/strong>/isU'                                    => '[b]$1[/b]',
      	'/<span style="text-decoration: line-through">(.+)<\/span>/isU'   => '[del]$1[/del]',
      	'/<span style="text-decoration:underline">(.+)<\/span>/isU'       => '[u]$1[/u]',
      	'/<big>(.+)<\/big>/isU'                                           => '[big]$1[/big]',
      	'/<small>(.+)<\/small>/isU'                                       => '[small]$1[/small]',
      	'/<span style="color:#(.+)">(.+)<\/span>/isU'                     => '[color=$1]$2[/color]',
      	'/<span style="color:#ff0000">(.+)<\/span>/isU'                   => '[red]$1[/red\]',
      	'/<span style="color:#ffff22">(.+)<\/span>/isU'                   => '[yellow]$1[/red\]',
      	'/<span style="color:#00bb00">(.+)<\/span>/isU'                   => '[green]$1[/red\]',
      	'/<span style="color:#0000bb">(.+)<\/span>/isU'                   => '[blue]$1[/red\]');
 	return preg_replace(array_keys($bbcode),array_values($bbcode),$text);
}
function post_view($string)
{
	return bblinks(nl2br(bbcode($string)));
}

// стутус пользователя
function online_status($user_log)
{
	$t = DB :: run() -> queryFetch("SELECT `last_time` FROM `users` WHERE `login` = ? ;", array($user_log));
	return ($t['last_time']+300 > TIME) ? ' <span style="color: limegreen">(on)</span> ' : ' <span style="color: red">(off)</span> ';
}

// юерпик
function userpic($user_log)
{
	$t = DB :: run() -> queryFetch("SELECT `userpic` FROM `users` WHERE `login` = ? ;", array($user_log));
    if($t > 0) $pic = '<img src="'.HOST.'/dist/upload/userpic/'.$t['userpic'].'" class="img"/>'; else $pic = '<img src="'.HOST.'/dist/upload/userpic/empty.jpg" class="img" alt="not found user" />';
    return $pic;
}

// Функция безопасного шифрования в MD5
function md5_hash($text)
{
	return md5(md5('Fs21eFS11').md5(md5($text)));
}

// Верхняя часть
function page_head($title, $text = 0)
{
	global $is_user, $user, $set, $div;
	require ROOT . '/dist/php/head.php';
}

// Нижняя часть
function page_foot()
{
 	global $set, $div;
	require ROOT . '/dist/php/end.php';
	exit;
}
// Функция отображения времени
function view_date($time)
{
	if(date('Y') ==date("Y", $time)) $timep= date("j M, H:i", $time); else $timep= date("j M Y, H:i", $time);
	$months_eng = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	$months_rus = array('янв','фев','мар','апр','мая','июн','июл','авг','сен','окт','ноя','дек');
	$timep = str_replace($months_eng,$months_rus,$timep);
	return $timep;
}
// К-во символов
function strlenx($str)
{
if (function_exists('mb_substr'))return mb_strlen($str);
if (function_exists('iconv'))return iconv_strlen($str);
return strlen($str);
}
// Переадресация
function redir ($to) {
 header ('Location: '.$to, true);
 exit;
}
// Функция обрезки текста
 function cut($str, $lenght) {
    $str = strip_tags($str);
    if (strlen($str) >= $lenght) {
        $wrap = wordwrap($str, $lenght, "~");
        $str_cut = substr($wrap, 0, strpos($wrap, "~"));
        $str_cut .= ' ...';
        return $str_cut;
    } else {
        $str_cut = $str . ' ...';
        return $str_cut;
    }}
// Склонение слов
function g_words($number, $num='тестов', $num1='тест', $num2='теста')
{
    		$num100 = $number % 100;
    		$num10 = $number % 10;
    		if ($num100 >= 5 && $num100 <= 20)
        		return $num;
    		else if ($num10 == 0)
        		return $num;
    		else if ($num10 == 1)
        		return $num1;
    		else if ($num10 >= 2 && $num10 <= 4)
        		return $num2;
    		else if ($num10 >= 5 && $num10 <= 9)
        		return $num;
    		else
        		return $num2;
}
?>