<?php

/**
 * @name FonMotivator
 * @author fonclub
 * @copyright 2012
 * @description Класс для создания демотиваторов и мотиваторов, включает в себя:
 * функции загрузки, ресайза картинок, траслитерации русских названий картинок и функцию создания демотиватора/мотиватора
 * @version v.1.0
 */

class FonMotivator{
    
    public $targetPath = './uploads'; // путь до папки загрузки
    public $fontpath = './fonts/'; // путь до папки со шрифтами
    public $font = 'arial.ttf'; // название шрифта
    public $copyright = "fonclub-blog.ru"; // копирайт
    public $title = 'Заголовок'; // заголовок по умолчанию
    public $text = 'здесь будет ваш текст'; // текст по умолчанию
    public $rbg = array(0,0,0); // цвет фона картинки (черный по умолчанию)
    public $width = 600; // ширина картинки при обрезании
    public $height = 400; // высота картинки при обрезании
    
    public function __construct(){
        if (!empty($_FILES)) {
        	$this->upload($_FILES);           
        }
        if ( isset($_POST['preview']) ){
            $this->Preview($_POST);
        }
    }
    
    /** функция первичной загрузки изображения*/
    public function upload($files){
        
            $tempFile = $files['Filedata']['tmp_name'];
            $file_name = $this->translit(md5(time()).$files['Filedata']['name']) ;
        	$targetFile = $this->targetPath . '/' . $file_name;           
        	
        	// Validate the file type
        	$fileTypes = array('jpg','jpeg','gif','png'); // File extensions
        	$fileParts = pathinfo($files['Filedata']['name']);
        	
        	if (in_array($fileParts['extension'],$fileTypes)) {	   
        	    $image = $this->resizeImage($tempFile, $targetFile, $this->width, $this->height, 0, 0, 0);
                                
                $original =  'original_' . $file_name;
                $originalsrc = $this->targetPath . '/original_' . $file_name;
                copy($image, $originalsrc);
                
                $this->demotivator($image,$this->title,$this->text,$this->copyright, $this->rbg);
                $data = array(
                    'img' => '<img src="'.$this->targetPath.'/'.$file_name.'" width="700" />', 
                    'original' => $original
                );
                echo json_encode($data);
                		
        	} else {
        		echo 'Разрешены только файлы изображений с расширениями .jpeg, .gif и .png!';
        	}
    }
    
    /** функция для генерации предпросмотра изображения*/
    public function Preview($data){
        
        $img = $this->targetPath. '/' . $data['original'];
        $newname = str_replace('/original_','/', $img);
        $newimg = str_replace('original_','', $data['original']);
        
        $title = $data['title'] ? urldecode($data['title']) : $this->title;
        $text = $data['text'] ? urldecode($data['text']) : $this->text;
        $rbg = ( $data['type'] == 'demotiv' or !isset($data['type']) )? $this->rbg : array(0,120,240);
        
        // $slogan1 = wordwrap($slogan1, 20, "\n");
        //$slogan2 = wordwrap($slogan2, 60, "\n");
        
        if (isset($data['action']) and $data['action'] = 'crop') /** если нужно обрезать - обрезаем картинку*/
        {
        	$img_r = imagecreatefromjpeg($newname);
        	$dst_r = ImageCreateTrueColor( $this->width, $this->height );
        
        	imagecopyresampled($dst_r,$img_r,0,0,$data['x'],$data['y'],$this->width,$this->height,$data['w'],$data['h']);
        	imagejpeg($dst_r,$img,100);
        }
        
        $image = $this->demotivator($img,$title,$text,$this->copyright, $rbg, $newname);
        $data['img'] = '<img src="'.$this->targetPath.'/'.$newimg.'?'.time().'" width="700" />';
        echo json_encode($data);
        //unlink($filename);

    exit;
    }
    
    /** доработанная функция создания демотиватора (автор Kalabzin Maxim Copyright (C) 6 авг. 2011.)*/
    public function demotivator($image, $title, $text, $copyright, $rbg=array(0,0,0), $newname=false) {
         
        $fontpath = $this->fontpath.$this->font;         
        $ext = getimagesize($image);         
         
        // Открываем изображение
        switch($ext[2]) {         
            case 2: {$img = ImageCreateFromJPEG($image); break;}
            case 1: {$img = ImageCreateFromGIF($image); break; }
            case 3: {$img = ImageCreateFromPNG($image); break;}
            case 6: {$img = ImageCreateFromBMP($image); break;}
            default : {
            	unlink ($image);
            	return 2;
            }         
        }       
         
        // Получение размеров изображения
        $x = ImageSX($img); // X
        $y = ImageSY($img); // Y        
         
        // Размер черного прямоугольника, который будем рисовать
        $tx = $x * 0.1;
        $ty = $x * 0.1;
         
        $bx = $x + $tx;
        $by = $y + $ty;
         
        $dx= $x * 0.01; // Смещение. Необходимо для рисования рамки
        $dy= $x * 0.01;
         
        // фон картинки
        list($r,$b,$g) = $rbg;
        $imgbg = ImageColorAllocate($img, $r, $b, $g);
         
        // Создаем новое изображение
        $img2 = ImageCreateTrueColor($bx + $tx, $by + $tx * 2.6);
        imagefill( $img2, 0, 0, $imgbg );
         
        // Масштабирование
        ImageCopyResized($img2, $img, $tx, $ty, 0, 0, $bx-$tx, $y, $x, $y);
         
         
        // Расчет смещений для рисования рамки
        $x1 = $tx;
        $y1 = $ty;
        $x2 = $bx;
        $y2 = $y + $ty;
         
        // Цвета рамки, слоганов и копирайта
        $col = ImageColorAllocate($img2, 255, 255, 255); // Цвет слоганов
        $col2 = ImageColorAllocate($img2, 255, 255, 255); // Цвет копирайта
        $col3 = ImageColorAllocate($img2, 255, 255, 255); // Цвет рамки
                
        // Рамки на изображении
        ImageRectangle($img2, $x1 - 5, $y1 - 5, $x2 + 4, $y2 + 4, $col3);
        ImageRectangle($img2, $x1 - 6, $y1 - 6, $x2 + 5, $y2 + 5, $col3);
                
        // Пишем слоганы, сначала с X=0, чтобы получить линейные размеры текста
        $s1 = ImageTTFText($img2, 0.06 * $bx, 0, $dx, $by + $ty, $col, $fontpath, $title);
        $s2 = ImageTTFText($img2, 0.035 * $bx, 0, $dx, $by + $ty + 0.08 * $bx, $col, $fontpath, $text);        
               
        // 1-й слоган не помещается в картинку - ошибка!
        if (($s1[2] - $s1[0]) > $bx + $tx) $sl1 = 1;        
         
        $dx = (($bx + $tx) - ($s1[2] - $s1[0]))/2; // Смещение. Эта величина определяет центровку текста для 1-го слогана
         
         
        // Непосредственно текст. 1-й слоган
        ImageFilledRectangle($img2, 0, $y2 + 10, $bx + $tx, $by + $tx * 2.8, $imgbg);
        ImageTTFText($img2, 0.06 * $bx, 0, $dx, $by + 1.1*$ty, $col, $fontpath, $title);
         
        $dx = (($bx + $tx) - ($s2[2] - $s2[0]))/2; // Смещение. Эта величина определяет центровку текста для 2-го слогана
         
         
        // Непосредственно текст. 2-й слоган (таглайн)
        if ($dx < 0)  {
         
        // Текст не умещается в картинку, масштабируем.
        $s = $s2[2] - $s2[0];
        $size = (0.035 * $bx * $bx) /$s;
        $s2 = ImageTTFText($img2, $size, 0, $dx, $by + $ty + 0.08 * $bx, $col, $fontpath, $text);
         
         
        $dx = (($bx + $tx) - ($s2[2] - $s2[0]))/2;
         
        ImageFilledRectangle($img2, 0, $by + 1.2* $tx, $bx + $tx, $by + $tx * 2.6, $imgbg);
        ImageTTFText($img2, $size, 0, $dx, $by + $ty + 0.08 * $bx, $col, $fontpath, $text);
         
        } else  {
         
        $size = 0.035 * $bx;
         
        ImageFilledRectangle($img2, 0, $by + 1.4*$tx, $bx + $tx, $by + $tx * 2.3, $imgbg);
        ImageTTFText($img2, $size, 0, $dx, $by + $ty + 0.08 * $bx, $col, $fontpath, $text);
         
        }
        
        // Copyright
        ImageTTFText($img2, 14, 0, $bx - 80, $by + $tx * 2.5, $col2, $fontpath, $copyright);
        
        if($newname) ImageJpeg($img2,$newname); // Если есть предыдущий файл - перезаписываем его
        else ImageJpeg($img2,$image);
        ImageDestroy($img2);        
    }
    
    /** функция ресайза изображения*/
    function resizeImage($src, $dest, $width, $height, $r=0,$g=0,$b=0, $quality=80)
    {
      if (!file_exists($src)) return false;
    
      $size = getimagesize($src);
    
      if ($size === false) return false;
    
      // Определяем исходный формат по MIME-информации, предоставленной
      // функцией getimagesize, и выбираем соответствующую формату
      // imagecreatefrom-функцию.
      $format = strtolower(substr($size['mime'], strpos($size['mime'], '/')+1));
      $icfunc = "imagecreatefrom" . $format;
      if (!function_exists($icfunc)) return false;
    
      $x_ratio = $width / $size[0];
      $y_ratio = $height / $size[1];
    
      $ratio       = min($x_ratio, $y_ratio);
      $use_x_ratio = ($x_ratio == $ratio);
    
      $new_width   = $use_x_ratio  ? $width  : floor($size[0] * $ratio);
      $new_height  = !$use_x_ratio ? $height : floor($size[1] * $ratio);
      $new_left    = $use_x_ratio  ? 0 : floor(($width - $new_width) / 2);
      $new_top     = !$use_x_ratio ? 0 : floor(($height - $new_height) / 2);
    
      $isrc = $icfunc($src);
      $idest = imagecreatetruecolor($width, $height);
    
      $rgb = imagecolorallocate($idest, $r, $g, $b);
      imagefill($idest, 0, 0, $rgb);
      imagecopyresampled($idest, $isrc, $new_left, $new_top, 0, 0, 
        $new_width, $new_height, $size[0], $size[1]);
    
      imagejpeg($idest, $dest, $quality);
    
      imagedestroy($isrc);
      imagedestroy($idest);
    
      return $dest;
    
    }  
     /** функция для транслитерации русских символов*/
    function translit($str){
        $alphavit = array(
        /*--*/
        "а"=>"a","б"=>"b","в"=>"v","г"=>"g","д"=>"d","е"=>"e",
        "ё"=>"yo","ж"=>"j","з"=>"z","и"=>"i","й"=>"i","к"=>"k","л"=>"l", "м"=>"m",
        "н"=>"n","о"=>"o","п"=>"p","р"=>"r","с"=>"s","т"=>"t",
        "у"=>"y","ф"=>"f","х"=>"h","ц"=>"c","ч"=>"ch", "ш"=>"sh","щ"=>"sh",
        "ы"=>"i","э"=>"e","ю"=>"u","я"=>"ya",
        /*--*/
        "А"=>"A","Б"=>"B","В"=>"V","Г"=>"G","Д"=>"D","Е"=>"E", "Ё"=>"Yo",
        "Ж"=>"J","З"=>"Z","И"=>"I","Й"=>"I","К"=>"K", "Л"=>"L","М"=>"M",
        "Н"=>"N","О"=>"O","П"=>"P", "Р"=>"R","С"=>"S","Т"=>"T","У"=>"Y",
        "Ф"=>"F", "Х"=>"H","Ц"=>"C","Ч"=>"Ch","Ш"=>"Sh","Щ"=>"Sh",
        "Ы"=>"I","Э"=>"E","Ю"=>"U","Я"=>"Ya",
        "ь"=>"","Ь"=>"","ъ"=>"","Ъ"=>""
        );
        return strtr($str, $alphavit);
    }          
}

$api = new FonMotivator();