$(function() {
	$("#upload").uploadify({
	    fileTypeDesc  : 'Изображения',
        fileTypeExts  : '*.gif; *.jpg; *.jpeg; *.png', 
        fileSizeLimit : '1MB',
		height        : 30,
		swf           : 'js/uploadify/uploadify.swf',
		uploader      : 'api.php',
		width         : 120,
		'buttonText' : 'Выбрать картинку',
		'onUploadSuccess' : function(file, data, response) {
			$('#text-box').css('display', 'block');
			$('.action-box').css('display', 'block');
			var src = $.parseJSON(data);
			$('#image-box').html(src.img);
			$('#original').val(src.original);
			setCrop();
		} 
	});        
});

function thisPreview(){
	var data = $('#preview').serialize();
	$.ajax({
	  url: 'api.php',
	  data: data+'&preview=1',
	  type: "post",
	  dataType: "json",
	  success: function(src) {
		$('#image-box').html(src.img);
		setCrop();
	  }
	});    
}

function Resize(){
	if(checkCoords()){
		var data = $('#preview').serialize();
		$.ajax({
		  url: 'api.php',
		  data: data+'&action=crop&preview=1',
		  type: "post",
		  dataType: "json",
		  success: function(src) {
			$('#image-box').html(src.img);
			setCrop();
		  }
		});   
	}           
}

function showCoords(img, selection) {
	$('#x').val(selection.x1);
	$('#y').val(selection.y1);
	$('#w').val(selection.width);
	$('#h').val(selection.height);
	if( confirm('Вырезать?') ) Resize();
}

function checkCoords()
{
	if (parseInt(jQuery('#w').val())>0) return true;
	alert('Выберите область картинки для обрезки!');
	return false;
};

function setCrop(){
	$('#image-box img').imgAreaSelect({
		handles: true,
		onSelectEnd: showCoords
	});
	resetCrop();
}

function resetCrop()
{
	$('#x').val('0');
	$('#y').val('0');
	$('#w').val('0');
	$('#h').val('0');
	$('.imgareaselect-outer').each(function(){
		$(this).css('display', 'none');
	});
};