<?php
class Navigator {

    function __construct($script,$pnumber,$query='') {
        $this->script=$script;
 
        if (empty($script)) {
            $this->script=$_SERVER['SCRIPT_NAME'];
        }
 
        $this->pnumber=$pnumber;
 
        $this->query='';
        $this->or_query=$query;
 
        if (is_array($query)) {
            foreach ($query as $k=>$v) {
                $this->query.='&amp;'.$k.'='.urlencode($v);
            }
        }
 
        $this->page=isset($_GET['page']) ? (int)$_GET['page'] : 1;
    }
 
    function start() {
 
        $this->start = $this->page * $this->pnumber - $this->pnumber;
 
        if ($this->page < 1) {
            $this->page=1;
            $this->start=0;
        }
 
        return $this->start;
    }
 
    function navi($all,$input=0) {
 
        $this->all=$all;
 
        $this->num_pages=ceil($this->all/$this->pnumber);
 
        if ($this->num_pages > 5) $input=1;
 
        if ($this->page > $this->num_pages || $this->page < 1) {
            $this->page=1;
            $this->start=0;
        }
		
        if ($this->num_pages<2)
        return '';
 
        $buff='<div class="gl"><center><ul class="pagination">';   

        // 
        if ($this->page>1)
        $buff.='<li><a href="'.$this->script.'page='.($this->page-1).$this->query.'" rel="next">&laquo;</a></li>';
        else
        $buff.='';
		
		for($pr = '', $i =1; $i <= $this->num_pages; $i++) {
            $buff.=
            $pr=(($i == 1 || $i == $this->num_pages || abs($i-$this->page) < 2) ? ($i == $this->page ? " 
			<li class='active'><span>$i</span></li> " : ' <li><a href="'.$this->script.'page='.$i.$this->query.'">'.$i.'</a></li> ') : (($pr == ' <li class="disabled"><span>...</span></li> ' || $pr == '')? '' : ' <li class="disabled"><span>...</span></li> '));
        }
 
        // 
        if ($this->page<$this->num_pages)
        $buff.='<li><a href="'.$this->script.'page='.($this->page+1).$this->query.'" rel="next">&raquo;</a></li>';
        else
        $buff.='';
		
        $buff.='</center></ul></div>';
        return $buff;
    }
}